set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614546';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1441',
      '42242130',
      NULL,
      83,
      '4330444',
      11,
      NULL,
      0.318791,
      2,
      NULL,
      5,
      ' 2- 9-2003',
      25.829988,
      17,
      1.237037,
      NULL,
      3,
      0.198108,
      2.681754,
      0.592877,
      1,
      2.210890,
      0,
      1.531305,
      1.151178,
      NULL,
      7,
      NULL,
      0.263173,
      0,
      NULL,
      1.240396,
      3,
      0,
      NULL,
      1.781549,
      1.696901,
      0.759340,
      0.593313,
      0,
      5.969545,
      1.116897,
      NULL,
      1.417300,
      NULL,
      NULL,
      1.914337,
      NULL,
      NULL,
      1,
      1.866126,
      NULL,
      0.348536,
      1,
      1.986398,
      3.202802,
      0.971804,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3.455828,
      2.200030,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      9.508454,
      1,
      2,
      NULL,
      0.604792,
      NULL,
      NULL,
      0.877140,
      NULL,
      NULL,
      0.032957,
      0,
      1,
      0,
      1.429359,
      0.840569,
      0,
      0.663235,
      1,
      1.372088,
      3.800468,
      NULL,
      NULL,
      2.497246,
      NULL,
      0.395599,
      NULL,
      NULL,
      1.535755,
      NULL,
      NULL,
      0.942788,
      NULL,
      1,
      1,
      0,
      0,
      1.713003,
      NULL,
      3,
      2.409570,
      0.989045,
      0,
      1.927804,
      NULL,
      0.460166,
      0,
      3.920337,
      1,
      4,
      3,
      0.446962,
      2.845803,
      0.618902,
      3.829622,
      1.669125,
      0,
      0.356426,
      3,
      1.332304,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.600307,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.238320,
      NULL,
      NULL,
      0.805155,
      NULL,
      3.515021,
      1,
      3.391224,
      5.543583,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.228037,
      0.560115,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.662765,
      NULL,
      NULL,
      0,
      1.035758,
      1.400585,
      NULL,
      1.390897,
      0,
      1.846920,
      0.382592,
      1.442218,
      1,
      0,
      0.734493,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523399,
      NULL,
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0.984429,
      '',
      '',
      '',
      4.292540,
      NULL,
      1,
      0.425562,
      NULL,
      0.386368,
      3,
      3,
      1);
commit;
end;
/


