set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7302006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '042',
      '44110023',
      0,
      10,
      '2311443',
      15,
      0,
      0.585988,
      0,
      NULL,
      4,
      ' 7-22-1985',
      25.065715,
      140.439391,
      1.602559,
      NULL,
      0,
      1.105010,
      2.156894,
      1.476055,
      NULL,
      1,
      NULL,
      0,
      0.654188,
      NULL,
      4,
      0,
      1,
      1,
      NULL,
      3,
      0.530980,
      1.456581,
      1.308818,
      0.547232,
      NULL,
      0.741014,
      5.600688,
      1,
      1.128346,
      NULL,
      0.141859,
      1.402670,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.682993,
      0.013357,
      0.565068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.279646,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325762,
      1,
      0.553965,
      1.852379,
      1,
      4,
      5,
      1,
      0.850889,
      0,
      0.837157,
      1,
      NULL,
      2.866487,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      5,
      0,
      0,
      NULL,
      3.848700,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261275,
      0,
      1.369868,
      NULL,
      1.277446,
      1.576382,
      7,
      4.470872,
      0.989241,
      7,
      6,
      0,
      5.309379,
      1,
      7.048467,
      3.191754,
      0.532258,
      NULL,
      NULL,
      0.612712,
      0.323568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.535577,
      1,
      NULL,
      NULL,
      1.467162,
      1.413597,
      0.815403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.400661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      7,
      5,
      2,
      NULL,
      1.960646,
      NULL,
      NULL,
      NULL,
      0.932047,
      3,
      0.450964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.934194,
      NULL,
      1.686718,
      1.882872,
      NULL,
      0.289312,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.314974,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025877,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      1.638016,
      NULL,
      0,
      3.450750,
      NULL,
      0.186331,
      2);
commit;
end;
/


