set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7302006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2220',
      NULL,
      77.105309,
      26,
      '0042004',
      57,
      NULL,
      0.556353,
      0,
      '141341',
      NULL,
      ' 8- 1-1979',
      16,
      144.340316,
      1.795975,
      NULL,
      1.551879,
      0.624332,
      1,
      1,
      1.855374,
      NULL,
      1.593587,
      1,
      1.418774,
      0,
      4,
      1,
      1,
      1,
      3.040647,
      1.153551,
      1,
      1.543074,
      NULL,
      0.646840,
      NULL,
      1.503180,
      NULL,
      0,
      0,
      3.216803,
      NULL,
      1.715670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499037,
      0.561400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150213,
      0.483390,
      0.495649,
      0.139706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542081,
      0,
      1.727013,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346014,
      0.247505,
      0,
      0,
      1.129759,
      1.276670,
      NULL,
      NULL,
      1,
      1.313132,
      0,
      NULL,
      0.089751,
      NULL,
      0,
      0,
      0.192588,
      NULL,
      NULL,
      3.851429,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094840,
      0,
      0.716190,
      0,
      5.109269,
      5,
      NULL,
      7.156467,
      6.961168,
      2.449498,
      5,
      7,
      4.148172,
      0,
      0.637894,
      0.970844,
      3,
      0,
      0,
      2,
      0.037520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026064,
      5.010427,
      0,
      NULL,
      1.077815,
      3.068897,
      1.519752,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.665603,
      NULL,
      4.639736,
      3.057248,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415107,
      1,
      NULL,
      0,
      0,
      0.742715,
      NULL,
      0.932421,
      0.484183,
      0,
      2,
      NULL,
      0,
      1.135782,
      NULL,
      0,
      1,
      NULL,
      0,
      1.125613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.330869,
      '33441',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      NULL,
      '',
      NULL,
      0.582939,
      3,
      3.858422,
      NULL,
      2.687810,
      1.635971,
      0,
      0.674594,
      1);
commit;
end;
/


