set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7302006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2144',
      '43101203',
      11,
      20,
      '2002341',
      82.303078,
      0,
      0,
      3,
      '144433',
      NULL,
      '11-17-1985',
      96.317903,
      41,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.437497,
      1,
      NULL,
      0.875963,
      0.789380,
      6.776645,
      NULL,
      1.444524,
      1.046154,
      1.064113,
      1.384276,
      0,
      0,
      1,
      0,
      1.766852,
      0.219867,
      2,
      0,
      0,
      2,
      0.505652,
      1.976822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.400162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763456,
      1.823272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991783,
      NULL,
      1,
      1,
      0.055291,
      0.011228,
      NULL,
      1,
      1.360439,
      NULL,
      NULL,
      0,
      0.654178,
      NULL,
      1.834313,
      NULL,
      0.489836,
      1,
      NULL,
      NULL,
      1.148703,
      2,
      2.585604,
      0.444008,
      NULL,
      5,
      0.848357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.428392,
      7.374581,
      4.309886,
      7,
      7,
      5.827490,
      8,
      7.824392,
      7,
      1,
      1,
      1.925231,
      NULL,
      1.717965,
      1.879888,
      NULL,
      7.024347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800671,
      NULL,
      NULL,
      0,
      0.888143,
      0.727753,
      0.671353,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.818734,
      NULL,
      NULL,
      NULL,
      NULL,
      0.103335,
      3,
      NULL,
      NULL,
      0,
      2,
      1.183055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737274,
      NULL,
      7.021278,
      0,
      2,
      1.415286,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.824488,
      0,
      1.018638,
      1,
      1,
      1.472066,
      NULL,
      1,
      2,
      2,
      1.981540,
      1.188289,
      0.975446,
      NULL,
      0.184302,
      1.551413,
      NULL,
      1.265401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '13400',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.134581,
      '',
      '',
      NULL,
      5,
      2,
      2,
      NULL,
      NULL,
      1,
      0.201446,
      NULL,
      NULL);
commit;
end;
/


