set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9976000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3223',
      '01422001',
      29.800126,
      2.636534,
      NULL,
      NULL,
      4,
      2.658104,
      3,
      '340100',
      NULL,
      ' 0- 6-1976',
      86.071757,
      23.262795,
      0.334377,
      NULL,
      2.392995,
      0,
      2,
      1.217215,
      1.950245,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.400784,
      NULL,
      0,
      NULL,
      1.723892,
      0,
      4,
      0.420927,
      1,
      3,
      1.118873,
      1.913931,
      3,
      1,
      NULL,
      1.980591,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0.697532,
      1.777476,
      3,
      0,
      1.459795,
      NULL,
      1,
      NULL,
      1.043091,
      3.961534,
      0,
      1,
      0,
      3,
      0,
      NULL,
      0,
      1,
      1.789048,
      0.837118,
      0,
      0,
      1,
      0,
      1.020617,
      0.110828,
      NULL,
      NULL,
      1.469654,
      NULL,
      NULL,
      1.658851,
      NULL,
      1,
      0,
      0,
      0,
      0.390705,
      0,
      1,
      1,
      1,
      NULL,
      0.966685,
      2.943786,
      0.976862,
      0.843399,
      1,
      1.004296,
      1.753791,
      NULL,
      1,
      1.151352,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      6,
      3,
      0,
      2.796092,
      4.348423,
      8,
      7,
      1,
      3.652510,
      9,
      2,
      6,
      5,
      5.955707,
      0,
      6,
      NULL,
      1.863291,
      0.322270,
      0,
      0.180722,
      0,
      1.773226,
      NULL,
      0.555547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.928585,
      1.386205,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.279003,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      9.070733,
      0,
      0.682472,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      6.616849,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.234234,
      1,
      1.949512,
      0.865070,
      2,
      0,
      NULL,
      1.730855,
      3,
      1,
      1,
      0.106792,
      NULL,
      1.897497,
      1.921559,
      0,
      0.810348,
      1.240882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.189151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.927915,
      1.772680,
      2.355735,
      53.807633,
      NULL,
      NULL,
      0,
      0,
      1.451731,
      '22103',
      '22303',
      '',
      NULL,
      '',
      '',
      '',
      0.954728,
      '',
      NULL,
      '',
      3,
      3.318880,
      1.536353,
      0,
      2,
      0.081038,
      NULL,
      NULL,
      3);
commit;
end;
/


