set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9976000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4102',
      '10311014',
      76.005612,
      5,
      '4333410',
      24,
      3,
      1.331266,
      2,
      NULL,
      1,
      ' 6- 5-1981',
      17,
      44,
      1.294743,
      NULL,
      NULL,
      0.145560,
      NULL,
      NULL,
      NULL,
      3.476950,
      1.210930,
      1,
      1.826737,
      1,
      3.074943,
      NULL,
      0.594594,
      NULL,
      1.523249,
      0,
      5.804941,
      0,
      1,
      1,
      0,
      1.770878,
      5.049764,
      0,
      3,
      3.720923,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.574445,
      1.893020,
      3,
      0.949081,
      1,
      1,
      3.226510,
      NULL,
      1.841363,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0.049268,
      0,
      NULL,
      1.944403,
      1.975577,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.037522,
      0,
      0,
      NULL,
      0,
      NULL,
      1.354372,
      0,
      1,
      0.871457,
      NULL,
      NULL,
      0.695464,
      2.094099,
      1,
      0.360581,
      1,
      0,
      1.598850,
      NULL,
      0.564433,
      0,
      0.631340,
      0,
      0.273635,
      0.220677,
      0,
      1.570805,
      5,
      NULL,
      0.410902,
      5.498687,
      0.896462,
      6,
      NULL,
      0,
      4.005704,
      NULL,
      NULL,
      5.360649,
      6,
      3,
      8,
      7,
      NULL,
      1.087388,
      1,
      0.780796,
      1,
      NULL,
      0.700633,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.330785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.946688,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936659,
      3.376509,
      6.673433,
      1.617269,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.712346,
      3,
      0.376352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041937,
      0,
      1.871624,
      1,
      NULL,
      NULL,
      2,
      0.336188,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1.744588,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.122228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.601636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94,
      0.448889,
      1,
      1.174707,
      1,
      2.019644,
      '12402',
      '43434',
      '',
      0,
      '',
      '',
      NULL,
      0.268747,
      '',
      '',
      '',
      0.601312,
      1.479149,
      0.620858,
      1,
      2.084015,
      3,
      NULL,
      3,
      0.279908);
commit;
end;
/


