set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9976000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0101',
      '40014441',
      44,
      NULL,
      '3200442',
      27.611072,
      1,
      NULL,
      NULL,
      '123411',
      1.375865,
      ' 5-20-2000',
      63.170854,
      6.456387,
      0.772284,
      NULL,
      2.173048,
      0.018431,
      1.369369,
      0.536646,
      0.011680,
      3.317372,
      1.594183,
      0.786021,
      1.083751,
      NULL,
      4,
      1.463516,
      1.150799,
      1.373053,
      0,
      1.184877,
      5.597951,
      1,
      1,
      0,
      0,
      0.951190,
      2,
      0,
      NULL,
      0.037443,
      2,
      1.622301,
      NULL,
      NULL,
      0.894480,
      NULL,
      NULL,
      1,
      0,
      1,
      0.096438,
      NULL,
      0,
      1.564262,
      0.993312,
      1,
      NULL,
      2,
      1,
      1,
      NULL,
      1,
      0,
      0.954168,
      0,
      0,
      1,
      1.468948,
      1,
      5,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.455171,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      4.679598,
      1,
      0.765211,
      NULL,
      0.067285,
      0,
      NULL,
      NULL,
      3,
      0.533600,
      1.157862,
      1.666838,
      0.615216,
      1.569070,
      NULL,
      0.211537,
      1.057187,
      3,
      4.236158,
      2.764166,
      1,
      7.750078,
      0,
      3,
      3,
      1,
      4,
      NULL,
      2,
      7,
      0,
      3.190838,
      2.793154,
      2.281752,
      8,
      NULL,
      2,
      7,
      5,
      3,
      1.133082,
      1,
      1,
      0,
      NULL,
      NULL,
      0.385672,
      0.066840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.193204,
      1.690710,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.428602,
      NULL,
      NULL,
      NULL,
      0.434171,
      0,
      4,
      2,
      1,
      1,
      1.192552,
      NULL,
      NULL,
      NULL,
      NULL,
      3.406835,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954211,
      0,
      3,
      2.745098,
      0.561175,
      3.716397,
      0.056056,
      1,
      0,
      3.554764,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.638167,
      1.294719,
      1,
      1.193989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.343209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.783372,
      1.303927,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '01321',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      1,
      NULL,
      NULL,
      0,
      2.144237,
      1,
      2,
      0);
commit;
end;
/


