set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '3222102',
      40.864451,
      2,
      NULL,
      NULL,
      '011411',
      1,
      NULL,
      41.536042,
      NULL,
      1,
      NULL,
      0.699876,
      3,
      0.671055,
      1.741833,
      NULL,
      0,
      1,
      1,
      2,
      1,
      0.209408,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.650652,
      1.462469,
      1.904486,
      NULL,
      2,
      0,
      NULL,
      2.786133,
      1.575936,
      1,
      NULL,
      NULL,
      1.191514,
      NULL,
      NULL,
      0,
      1.431105,
      0.540978,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.928563,
      1,
      1.864916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.860281,
      NULL,
      0,
      1,
      1.747219,
      1.200548,
      0.291697,
      NULL,
      0,
      0.984430,
      NULL,
      NULL,
      0,
      0.323081,
      NULL,
      0.777616,
      0,
      1,
      NULL,
      0.616919,
      1.351452,
      0,
      0,
      3.181930,
      0.283610,
      4.656830,
      0,
      0.151921,
      NULL,
      1.439428,
      1,
      0,
      NULL,
      1.387155,
      NULL,
      NULL,
      0,
      0.965346,
      1,
      NULL,
      6.410724,
      4.694936,
      1,
      7.753898,
      NULL,
      0.947529,
      1,
      0,
      NULL,
      NULL,
      2.526825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773598,
      0.413986,
      0,
      0,
      1.825163,
      0.740485,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681592,
      NULL,
      NULL,
      0.337875,
      0,
      5,
      2,
      1.073058,
      NULL,
      NULL,
      NULL,
      0.153497,
      0.492310,
      1,
      2.250281,
      0.631513,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.028786,
      3,
      1.085065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.813095,
      NULL,
      1.956373,
      1,
      3,
      NULL,
      0,
      0,
      0.416254,
      1.312877,
      1,
      1,
      NULL,
      1.265270,
      0.838098,
      NULL,
      NULL,
      0.057749,
      1.486756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.724012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.116576,
      '21333',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0.035744,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


