set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '011',
      NULL,
      1,
      8,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      '322223',
      NULL,
      NULL,
      16,
      11,
      0,
      NULL,
      0.238130,
      0,
      3,
      1,
      NULL,
      NULL,
      1,
      0.577033,
      NULL,
      0.151760,
      NULL,
      1.601216,
      0.471029,
      2,
      2,
      0,
      1.795730,
      NULL,
      1,
      1.981602,
      7.503283,
      1.268508,
      NULL,
      NULL,
      0.915848,
      0.515056,
      2,
      0,
      NULL,
      NULL,
      0.577735,
      NULL,
      NULL,
      1,
      1.783781,
      1.524011,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.006498,
      0,
      2,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.675060,
      NULL,
      NULL,
      1.568968,
      1.007364,
      7.845465,
      0.102925,
      6,
      0.211568,
      1.084622,
      1.057712,
      0.936020,
      NULL,
      0.393256,
      0,
      1,
      2,
      1,
      1.301891,
      1,
      1.977898,
      0.345283,
      NULL,
      1.568988,
      NULL,
      1.217552,
      NULL,
      3.866807,
      1.410163,
      NULL,
      0.498879,
      4,
      0.474836,
      1.112346,
      0,
      0,
      2,
      2.938736,
      1.301203,
      1,
      3.246138,
      0,
      5.140815,
      7,
      NULL,
      6,
      4,
      7.986554,
      1.233989,
      NULL,
      1.312306,
      NULL,
      1,
      0.568132,
      2.098703,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567500,
      0.791581,
      0,
      NULL,
      1,
      1,
      1.536141,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.313716,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.531413,
      1,
      1,
      3,
      2.907080,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.411127,
      NULL,
      0.252529,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.870894,
      1,
      0,
      0.162353,
      1.297203,
      1,
      NULL,
      2.667274,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1.728041,
      0.610999,
      0.835787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.099510,
      '30424',
      '',
      '',
      1.616858,
      NULL,
      '',
      '',
      1.456590,
      '',
      '',
      NULL,
      0.321251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


