set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '014',
      '30100332',
      26.240487,
      NULL,
      '1010024',
      143.784726,
      3,
      1,
      3,
      NULL,
      2,
      ' 7- 8-1989',
      12,
      65,
      0.307204,
      NULL,
      1,
      0.269654,
      0.089199,
      1.500153,
      1,
      0,
      1.954930,
      1,
      3,
      1.543760,
      2.769152,
      1,
      0,
      NULL,
      NULL,
      0,
      0.969791,
      3,
      1.819353,
      1,
      9.929494,
      NULL,
      4,
      1,
      3.504244,
      0,
      2,
      1.057100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366823,
      1,
      2.167743,
      NULL,
      NULL,
      1,
      1.317362,
      0,
      1,
      0,
      1,
      0,
      1.583061,
      NULL,
      1,
      0,
      0,
      1.176477,
      NULL,
      NULL,
      1,
      1.136134,
      NULL,
      1.123563,
      1.469516,
      1,
      0,
      0,
      1,
      1.214801,
      NULL,
      1.149201,
      NULL,
      4.247183,
      2,
      1,
      0,
      4.162137,
      2,
      4,
      5,
      0,
      3,
      NULL,
      5.857615,
      0,
      0.283895,
      0.493243,
      3.195891,
      0,
      1.350374,
      NULL,
      1.757570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806896,
      NULL,
      0,
      0,
      0,
      0.560225,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.860807,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      2.406675,
      1,
      4.427282,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.191164,
      1,
      1.664142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569230,
      0.434063,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.200629,
      0,
      1.595172,
      NULL,
      NULL,
      NULL,
      2.243377,
      1,
      0,
      0.867610,
      0.817562,
      0.110619,
      0.313099,
      0.174830,
      0,
      1.896256,
      0,
      0.701510,
      0.678529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '43330',
      '',
      '',
      1,
      '',
      '',
      '',
      1.765661,
      '',
      NULL,
      NULL,
      2.206520,
      0.734611,
      1.541969,
      NULL,
      2.678297,
      0.328757,
      NULL,
      3,
      2.000838);
commit;
end;
/


