set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '144',
      '41132414',
      34.118189,
      26.905384,
      '2023022',
      112,
      5,
      0.839717,
      NULL,
      '032210',
      2,
      ' 6- 1-1981',
      NULL,
      33,
      0,
      NULL,
      1.216388,
      NULL,
      0.197070,
      NULL,
      0,
      1.909978,
      NULL,
      0.048002,
      0.696743,
      1,
      1,
      1,
      0,
      1.569956,
      5.409382,
      0,
      0.741405,
      0,
      NULL,
      0,
      1.755706,
      1,
      NULL,
      0,
      5.065728,
      2,
      2.327979,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.346328,
      0,
      1.946344,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.339121,
      NULL,
      NULL,
      0,
      0.570302,
      3.924906,
      1.860960,
      3,
      0,
      1.937449,
      0,
      1.479607,
      1.305223,
      1.688219,
      0,
      0,
      0.789354,
      1.416333,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0.780688,
      NULL,
      1,
      1.324506,
      1.589200,
      1,
      NULL,
      1.016125,
      NULL,
      0.182096,
      NULL,
      1,
      1.004467,
      1.804401,
      1.990321,
      4,
      1.455298,
      NULL,
      4.933229,
      2,
      1.486416,
      4.017213,
      2.788453,
      0.145869,
      0.652610,
      NULL,
      3.736303,
      1.966534,
      0.183962,
      3.919544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.829762,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.192990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.810995,
      1,
      NULL,
      1.843978,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.901790,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.164907,
      NULL,
      2,
      3.067463,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      0.343430,
      0.606009,
      1.600617,
      0.068638,
      NULL,
      0.956076,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.459285,
      '11412',
      '',
      '',
      1.838691,
      '',
      '',
      NULL,
      0.758452,
      '',
      '',
      '',
      4,
      3.558157,
      3,
      1,
      0.104962,
      3,
      3.836931,
      NULL,
      NULL);
commit;
end;
/


