set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '340',
      NULL,
      71.257938,
      NULL,
      '4134324',
      NULL,
      3,
      1.758601,
      NULL,
      '431131',
      NULL,
      ' 6-18-1979',
      32,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1.210896,
      NULL,
      0,
      0.464223,
      3,
      1,
      1,
      NULL,
      0.349757,
      NULL,
      0.746413,
      NULL,
      2,
      0.116477,
      0,
      0,
      3.542709,
      1,
      7,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.732916,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.746774,
      1.851486,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.035398,
      2,
      NULL,
      1.721032,
      0,
      NULL,
      1.884539,
      1.758081,
      1.114145,
      1,
      1,
      1,
      1,
      1.891721,
      NULL,
      NULL,
      NULL,
      NULL,
      1.797944,
      NULL,
      0,
      1.580740,
      0,
      1.896952,
      NULL,
      1,
      3,
      3.042417,
      1.894602,
      1.809789,
      5.233489,
      NULL,
      0,
      1.613066,
      0.764129,
      NULL,
      NULL,
      2,
      0.353232,
      6.599834,
      NULL,
      NULL,
      4.211455,
      0.576950,
      1.410363,
      0,
      NULL,
      NULL,
      NULL,
      9,
      0.318467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973870,
      NULL,
      0,
      0,
      0,
      1.385927,
      1,
      0.073383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.786844,
      1.105397,
      1.221648,
      NULL,
      0.646859,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820005,
      NULL,
      0,
      0.326376,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.467319,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.426207,
      0.466138,
      2,
      NULL,
      NULL,
      1.046871,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1.792531,
      1.234976,
      NULL,
      0.467797,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.791812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '14240',
      NULL,
      '',
      1.968842,
      '',
      '',
      '',
      0.623011,
      '',
      NULL,
      '',
      2.484758,
      1,
      NULL,
      0.836463,
      NULL,
      NULL,
      0.029846,
      NULL,
      1);
commit;
end;
/


