set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '124',
      '20021114',
      52,
      78.177495,
      '0333114',
      NULL,
      3,
      5,
      NULL,
      NULL,
      3.014466,
      ' 7- 2-1977',
      NULL,
      24,
      0,
      NULL,
      0,
      1.618567,
      0.732974,
      NULL,
      0,
      NULL,
      NULL,
      1.625216,
      1,
      0.705041,
      0.212063,
      1.904025,
      0,
      2.063937,
      0.882499,
      2,
      4.604519,
      4,
      3,
      1.341676,
      7,
      1,
      4,
      1,
      5.047505,
      2.230745,
      3.160122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.925632,
      0,
      1,
      1.198282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.639617,
      NULL,
      1.832751,
      1.408335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.270785,
      0,
      3,
      3,
      1.056426,
      0,
      NULL,
      0.313918,
      NULL,
      1,
      0.727765,
      0,
      NULL,
      1.571708,
      0.817733,
      NULL,
      0,
      0,
      0.831319,
      NULL,
      0.782502,
      1.649894,
      1.823912,
      1,
      1.757490,
      NULL,
      0.464617,
      0.570420,
      5,
      5,
      0,
      0.918054,
      0.460668,
      5.353526,
      0.614795,
      1.509593,
      4,
      1.917593,
      0.923395,
      NULL,
      2.284803,
      NULL,
      4,
      2.974896,
      9,
      1.216308,
      0,
      0,
      NULL,
      0.654019,
      0.402505,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087039,
      0,
      0,
      NULL,
      0,
      1,
      0.016653,
      0.406626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      NULL,
      NULL,
      2,
      2.157703,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.071011,
      0.971577,
      1.720464,
      0,
      1.791341,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.756353,
      0.152224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308628,
      2,
      NULL,
      1.272610,
      NULL,
      0.468115,
      2.069224,
      2,
      0,
      0.269872,
      1.997155,
      0,
      1,
      1.564352,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      3.794310,
      1,
      0,
      1.981542,
      0.088930,
      NULL);
commit;
end;
/


