set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1420',
      '13013300',
      44.708468,
      39,
      NULL,
      281.561798,
      0,
      2.654215,
      NULL,
      '111302',
      5,
      ' 6- 0-2000',
      11.607845,
      19.139662,
      0.791891,
      NULL,
      2,
      0,
      3,
      0.401453,
      1,
      0,
      1.753598,
      1.207366,
      NULL,
      1.068677,
      2,
      NULL,
      1.843491,
      1.763901,
      3.676981,
      NULL,
      0,
      4,
      0.686281,
      NULL,
      8,
      0,
      2.301447,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.226821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999814,
      1.016941,
      NULL,
      1,
      0,
      1,
      1,
      0.447837,
      1,
      0,
      NULL,
      0.709047,
      1.872693,
      NULL,
      0.383967,
      0,
      NULL,
      0.348274,
      0.121846,
      NULL,
      0,
      4,
      NULL,
      1.138283,
      3,
      0.929156,
      NULL,
      0.180076,
      2,
      1,
      4,
      1.617226,
      1.664064,
      3,
      0.002581,
      0.287695,
      NULL,
      6,
      5,
      4.231804,
      2,
      3,
      NULL,
      NULL,
      9,
      0.681227,
      0.091013,
      NULL,
      0,
      NULL,
      0,
      7.139267,
      0.237416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751852,
      1.833463,
      0,
      1,
      0,
      1.039144,
      1.279080,
      0.555415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.781005,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.637773,
      2.194663,
      0,
      NULL,
      NULL,
      NULL,
      1.972658,
      NULL,
      1.719266,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.247870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641530,
      1.350222,
      2.973587,
      2,
      0.809082,
      NULL,
      NULL,
      0.883197,
      1.481559,
      2.208518,
      1,
      1,
      0.365629,
      0.676952,
      1,
      0,
      0.833371,
      0.452456,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      '',
      1.180178,
      '',
      '',
      '',
      5.180016,
      NULL,
      '4220',
      '',
      1.721876,
      NULL,
      0.962548,
      4,
      3,
      1,
      NULL,
      1,
      0.216184);
commit;
end;
/


