set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0133',
      NULL,
      NULL,
      NULL,
      '4330423',
      314.816679,
      4,
      2.634227,
      1,
      '014340',
      NULL,
      ' 1-22-2001',
      NULL,
      53.199001,
      1.124408,
      NULL,
      1.859534,
      0.078303,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.244952,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      2.615695,
      0,
      1.528073,
      1.187847,
      1.092373,
      0,
      1,
      1.369842,
      3,
      0,
      5.025880,
      4.614089,
      NULL,
      0.055687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055829,
      0.888348,
      0,
      0.955518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.322185,
      0.572605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.132517,
      1,
      0,
      1.644787,
      1.987406,
      1.605980,
      0,
      1,
      NULL,
      0,
      NULL,
      0.377460,
      1,
      NULL,
      1.767499,
      1,
      NULL,
      0.613288,
      NULL,
      1.526451,
      1,
      0,
      NULL,
      NULL,
      0.339804,
      0.306943,
      0,
      4.050952,
      NULL,
      2.486993,
      NULL,
      2.006039,
      0.975786,
      4,
      1,
      NULL,
      3.689905,
      0,
      4.454136,
      3,
      0.039658,
      3,
      3,
      6,
      0.832876,
      1.483167,
      1.724408,
      3.828857,
      1.903689,
      1.650556,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.915905,
      1.047087,
      1,
      NULL,
      0,
      0.495701,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.653400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.674569,
      0.602400,
      NULL,
      NULL,
      NULL,
      1,
      1.265762,
      0.270911,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.078336,
      1,
      0.891038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.989384,
      NULL,
      0.581543,
      2.058999,
      3,
      0.550059,
      1.538794,
      0.751439,
      NULL,
      0,
      0,
      1.797028,
      1,
      0,
      0.471502,
      1.451266,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.350594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '34203',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      1.334064,
      3.511047,
      1,
      1.778327,
      3,
      NULL,
      3.391813,
      2.302872,
      1);
commit;
end;
/


