set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314770';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '04413200',
      NULL,
      43,
      '4342333',
      0.863091,
      5,
      3,
      2,
      '003112',
      NULL,
      ' 3-22-1997',
      29,
      NULL,
      0,
      NULL,
      3,
      2,
      1.568979,
      1,
      2,
      NULL,
      1.982793,
      1,
      1,
      0.988355,
      1,
      1,
      1.745570,
      1,
      1,
      1,
      3,
      1,
      1.978475,
      0.660745,
      1.076211,
      1.522372,
      2.012672,
      0,
      2,
      1.790326,
      0.938330,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.974222,
      0,
      NULL,
      1.522894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.497935,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661499,
      NULL,
      3.341627,
      NULL,
      2,
      1.370568,
      0,
      1.172168,
      1,
      1.773958,
      0,
      NULL,
      0.488940,
      0.363554,
      1,
      1.637438,
      0,
      0,
      0,
      NULL,
      1.285659,
      0.172261,
      0.697658,
      0,
      1.218312,
      0,
      2.582610,
      0,
      NULL,
      0.889431,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      4.052477,
      3,
      4,
      6.469882,
      4,
      NULL,
      0.829384,
      1.980432,
      0.161174,
      0.738825,
      0,
      NULL,
      NULL,
      NULL,
      1.595565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357816,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766027,
      2,
      1,
      1,
      NULL,
      2,
      2.764220,
      1.958112,
      0.209225,
      NULL,
      NULL,
      NULL,
      1,
      0.216452,
      1.809737,
      NULL,
      NULL,
      0,
      1.300771,
      NULL,
      NULL,
      NULL,
      1.671000,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636512,
      1.107419,
      0,
      NULL,
      0,
      0.871537,
      0,
      NULL,
      1,
      1,
      0.841645,
      NULL,
      0,
      NULL,
      1.704989,
      1,
      0.605149,
      0,
      NULL,
      NULL,
      0.618880,
      0,
      1.377964,
      NULL,
      0,
      1,
      3.420438,
      0,
      0.311837,
      1,
      1.054025,
      0.730827,
      1.686152,
      NULL,
      0,
      3,
      0.742991,
      1.938934,
      NULL,
      0,
      0.933602,
      0.266219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.141327,
      NULL,
      '21113',
      '',
      0.097762,
      '',
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      2.887532,
      3.269791,
      1,
      3.677261,
      3,
      7,
      3.773194,
      2.252141,
      1);
commit;
end;
/


