set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314770';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0100',
      NULL,
      53.454359,
      NULL,
      '4402130',
      35.488945,
      6,
      3.508439,
      2,
      '314422',
      0,
      ' 2-17-1990',
      36,
      35,
      NULL,
      NULL,
      2,
      3,
      1.986016,
      0,
      0.100016,
      0.165384,
      1,
      0.062873,
      1,
      1.991320,
      1,
      0.403639,
      1.036221,
      0,
      1,
      1.801367,
      NULL,
      NULL,
      1.607217,
      0.682955,
      1,
      0,
      2.204019,
      1,
      0.381468,
      NULL,
      0.927314,
      0,
      NULL,
      NULL,
      1.249446,
      NULL,
      NULL,
      2.889107,
      0,
      1.664702,
      1.686906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.410371,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.292647,
      0,
      NULL,
      1.377077,
      0.271412,
      1.577688,
      1,
      4,
      0.761158,
      1.243539,
      NULL,
      2,
      0,
      0.363604,
      NULL,
      NULL,
      0.446833,
      NULL,
      0,
      1.164308,
      NULL,
      0,
      0.047283,
      0,
      0.336409,
      0.574062,
      1.974882,
      1,
      0,
      1.205720,
      NULL,
      0.305691,
      0.212008,
      0,
      7,
      5,
      NULL,
      1.925500,
      0,
      2,
      7,
      NULL,
      2.921959,
      1.113960,
      1.241021,
      1,
      1.522672,
      NULL,
      NULL,
      0.550894,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.881287,
      0,
      1,
      1.864504,
      1,
      0.187067,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.343563,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689792,
      0,
      0.186042,
      0,
      0.866118,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.579527,
      3,
      3.109844,
      NULL,
      1.479444,
      0.986055,
      0.740557,
      1.312205,
      NULL,
      3.033970,
      0.684720,
      0.978470,
      1.093709,
      1,
      1,
      1.895664,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.892841,
      '02041',
      '12320',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      5.973716,
      3,
      1.557019,
      0.383482,
      2.308358,
      7,
      2.090608,
      1.410692,
      NULL);
commit;
end;
/


