set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314770';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1230',
      '04011341',
      33,
      12.106481,
      '3142331',
      40,
      1,
      1.007216,
      NULL,
      '402130',
      1,
      ' 2- 3-1998',
      11,
      7.446581,
      0,
      NULL,
      NULL,
      2,
      1,
      1.607860,
      NULL,
      1,
      NULL,
      NULL,
      0.782768,
      NULL,
      5,
      0,
      1,
      1,
      1.512675,
      NULL,
      5,
      0.356382,
      1.336325,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.928645,
      NULL,
      1.296891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.352216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.857316,
      1,
      3.158663,
      1,
      2,
      0,
      NULL,
      2.749242,
      1.915290,
      0.117382,
      0.946130,
      5,
      1.803297,
      1.440071,
      0,
      0,
      0.607024,
      NULL,
      0.465398,
      0,
      0,
      NULL,
      1.748004,
      NULL,
      0,
      0,
      0.615674,
      NULL,
      1,
      1.593179,
      0.112051,
      1.510105,
      1.223997,
      0.456999,
      7.587304,
      5,
      NULL,
      3,
      4.694322,
      NULL,
      NULL,
      8,
      1,
      0.653643,
      5.899299,
      0.086467,
      0.505261,
      NULL,
      NULL,
      NULL,
      1.940446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.109453,
      0,
      0,
      0.065492,
      1.920539,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.282805,
      NULL,
      NULL,
      NULL,
      NULL,
      1.841992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728486,
      0.638453,
      NULL,
      1,
      NULL,
      1,
      1.719952,
      NULL,
      NULL,
      NULL,
      0.054439,
      0.343136,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597465,
      NULL,
      0.527179,
      3,
      3,
      2,
      NULL,
      0.155816,
      3,
      3,
      NULL,
      1,
      0,
      1.214158,
      0,
      0.530236,
      0.763558,
      1.914944,
      0.195938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '10421',
      '04301',
      NULL,
      0.302247,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      0.577211,
      1,
      NULL,
      NULL,
      5,
      0.007016,
      2,
      3,
      3.304069);
commit;
end;
/


