set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314770';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2240',
      '01140141',
      53,
      NULL,
      '0331200',
      15,
      6,
      3,
      NULL,
      '122032',
      5.936336,
      ' 0-18-1981',
      20,
      41.093967,
      0,
      NULL,
      0.438353,
      0.080911,
      0.833059,
      0,
      2.783372,
      0,
      1.945054,
      NULL,
      1,
      1.805493,
      4,
      0,
      0,
      NULL,
      0,
      0,
      2.810639,
      1,
      0.192869,
      0,
      1,
      0,
      0,
      0,
      0.390034,
      0.168690,
      1,
      1.913450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.878458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.520715,
      0.787520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.135966,
      0,
      1.223393,
      NULL,
      2,
      0.999674,
      0,
      4.583868,
      0.930405,
      0.100185,
      NULL,
      1.989756,
      1.041569,
      0,
      0.120935,
      0.959546,
      0.473969,
      NULL,
      0,
      1.473705,
      NULL,
      0.263866,
      1,
      0,
      0,
      NULL,
      NULL,
      1.779358,
      NULL,
      1,
      1.416647,
      1.237782,
      1.985336,
      0.902932,
      1,
      1,
      2,
      1.233246,
      2.440320,
      3.340556,
      6,
      5,
      NULL,
      1.016259,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.171986,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854151,
      0,
      1,
      0,
      0,
      1.812525,
      NULL,
      0.519016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.785763,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.391021,
      1.538665,
      1,
      1,
      0.231998,
      2,
      1.774305,
      NULL,
      NULL,
      NULL,
      0,
      0.921733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.083280,
      2,
      0.050599,
      0,
      NULL,
      3,
      NULL,
      1.725623,
      0.886246,
      NULL,
      NULL,
      0.995601,
      1.646380,
      1.835711,
      0,
      1,
      NULL,
      1.271992,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '04004',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      5.912780,
      6.411167,
      1.585572,
      3,
      3,
      0,
      2.016035,
      3,
      3.478054);
commit;
end;
/


