set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000796';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '433',
      NULL,
      13,
      37.297845,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      ' 3-19-1995',
      21.141786,
      43,
      1.004882,
      NULL,
      1,
      2.618288,
      0.771846,
      0.665356,
      NULL,
      0.441817,
      NULL,
      1.059827,
      0.328204,
      0,
      0.483055,
      1,
      0.627376,
      1.041568,
      1,
      0,
      0.705132,
      1.876518,
      NULL,
      1,
      1,
      1.861481,
      0.972488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453126,
      1,
      0.574631,
      0.455461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031935,
      0,
      4,
      0.618479,
      NULL,
      NULL,
      0.466578,
      0,
      NULL,
      NULL,
      1.866771,
      NULL,
      NULL,
      1.667285,
      0.070818,
      1.975106,
      0.788944,
      0.030811,
      0.324309,
      1.826182,
      1.974314,
      0.025940,
      1,
      1.479866,
      0.939178,
      0,
      0,
      1.477905,
      0,
      NULL,
      0.369573,
      1.410045,
      NULL,
      1,
      3.257890,
      0.993707,
      0,
      1.389458,
      1,
      NULL,
      1.207375,
      1,
      0.965014,
      NULL,
      1,
      1.289932,
      1.082471,
      4,
      NULL,
      3.953304,
      4.645650,
      0.876814,
      NULL,
      4.483745,
      1,
      NULL,
      7.864832,
      2,
      NULL,
      NULL,
      4.909331,
      1.029475,
      NULL,
      NULL,
      5.816943,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0.533859,
      1,
      0.533813,
      1.847361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3,
      NULL,
      1.296464,
      NULL,
      4.096249,
      NULL,
      1.383257,
      NULL,
      NULL,
      NULL,
      3.273399,
      2.235229,
      6.334042,
      2,
      1.351659,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      5.544578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.134158,
      2,
      0.427805,
      1,
      3.117284,
      0.977185,
      NULL,
      0.374557,
      NULL,
      1,
      3.160891,
      0.396615,
      1.958167,
      1.222710,
      1,
      NULL,
      0,
      1,
      1.654422,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      2,
      1,
      2,
      3.749455,
      2.651918,
      1,
      1,
      1);
commit;
end;
/


