set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000796';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '133',
      '20211211',
      NULL,
      4,
      '1030324',
      22.394831,
      4,
      1.190586,
      3,
      '244341',
      5.064133,
      NULL,
      28,
      6,
      1.779423,
      NULL,
      NULL,
      1.591261,
      NULL,
      1.585158,
      NULL,
      0,
      2,
      1,
      0.639814,
      0.498820,
      2.865815,
      1.173881,
      1.331066,
      1.658222,
      1.957320,
      4.912835,
      NULL,
      0.969450,
      1.119298,
      0.104491,
      1,
      0.490507,
      1,
      0,
      1,
      NULL,
      NULL,
      0.590977,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675209,
      0.778035,
      7,
      NULL,
      NULL,
      NULL,
      1.853242,
      1.434468,
      NULL,
      NULL,
      1.143596,
      NULL,
      NULL,
      0,
      1,
      0.294727,
      0,
      0.135975,
      NULL,
      1.653537,
      0,
      1,
      0.144785,
      NULL,
      1,
      1,
      1.835914,
      0,
      NULL,
      1.913860,
      NULL,
      NULL,
      NULL,
      0,
      1.697705,
      1.726216,
      1,
      3.514100,
      1,
      1.638732,
      1.328338,
      1,
      2,
      4,
      3,
      0.301355,
      NULL,
      4,
      2.386154,
      0.426553,
      1,
      0,
      5,
      5,
      NULL,
      5,
      NULL,
      1.292393,
      2,
      3,
      3,
      NULL,
      NULL,
      NULL,
      4.480367,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      2,
      1,
      1.146172,
      0.136947,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.456023,
      3,
      3.302159,
      NULL,
      0,
      NULL,
      NULL,
      3.372102,
      1,
      NULL,
      NULL,
      NULL,
      5.842188,
      NULL,
      5,
      NULL,
      3.182793,
      0,
      1.260534,
      1.282906,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160582,
      1,
      3,
      1,
      3.025680,
      NULL,
      1,
      1,
      2,
      0.803552,
      0,
      1,
      1,
      0.143407,
      0,
      NULL,
      1.697264,
      0.106496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.860732,
      '20402',
      '1044',
      '',
      0,
      '',
      '',
      '',
      0.906486,
      '',
      '',
      '',
      NULL,
      4.276733,
      0,
      2.465479,
      1.135782,
      0,
      2,
      2,
      0);
commit;
end;
/


