set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000796';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '043',
      NULL,
      31.462315,
      72,
      '1432130',
      11,
      2,
      NULL,
      2,
      '123324',
      2,
      ' 0- 3-1999',
      47,
      24.557053,
      1.513373,
      NULL,
      0,
      0,
      0.859554,
      NULL,
      2,
      1.566553,
      1,
      1,
      1.707781,
      1,
      3,
      0.195692,
      1.418516,
      NULL,
      1.694344,
      0,
      2.576915,
      1,
      1,
      NULL,
      1.378938,
      1.968347,
      NULL,
      1,
      0.622289,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.691934,
      NULL,
      1.765338,
      1.697390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907612,
      1,
      5.290189,
      4.125208,
      0,
      1,
      1.227430,
      1.153038,
      NULL,
      NULL,
      0.193611,
      NULL,
      NULL,
      1.661212,
      3.823103,
      NULL,
      0.055825,
      0,
      NULL,
      0,
      0.652642,
      NULL,
      1.998461,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0.872836,
      0.199149,
      1,
      0.323165,
      1.893057,
      1,
      4,
      NULL,
      0.653735,
      2.253467,
      4,
      5.632129,
      1,
      NULL,
      NULL,
      3.614996,
      0.128463,
      2,
      7,
      NULL,
      5.359078,
      0.414732,
      3.518936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.172882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      1.168675,
      1.182503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.535819,
      1.352624,
      1,
      0.569506,
      4,
      1.539607,
      1,
      NULL,
      NULL,
      NULL,
      0.176914,
      NULL,
      3,
      0,
      0.545409,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1.149786,
      3.518280,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.343310,
      0,
      3.879051,
      NULL,
      1,
      3,
      0,
      0.669517,
      0,
      NULL,
      1.554939,
      1,
      NULL,
      0.266197,
      0.875340,
      1,
      1.908912,
      0.930851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.119193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.808763,
      '00404',
      NULL,
      NULL,
      1,
      '',
      '',
      NULL,
      1,
      '4242',
      '',
      '',
      NULL,
      5.969688,
      1,
      3.712843,
      0.999161,
      3.739066,
      3.839076,
      2.394764,
      3);
commit;
end;
/


