set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000796';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '23014201',
      NULL,
      79,
      '4223333',
      6,
      4,
      NULL,
      NULL,
      NULL,
      2.411364,
      ' 5-16-1997',
      56.424760,
      36.957089,
      NULL,
      NULL,
      3,
      1.257995,
      NULL,
      NULL,
      3.783139,
      0,
      1.000729,
      0,
      0.825782,
      0.295012,
      0.634670,
      0.842966,
      NULL,
      0.010027,
      2,
      1,
      5.561083,
      1,
      1,
      0.156445,
      1,
      0.616279,
      5.962060,
      0,
      1,
      1.760593,
      0.771229,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.320801,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824557,
      1,
      NULL,
      3.406429,
      0,
      2,
      1.530394,
      NULL,
      NULL,
      NULL,
      1.949834,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186563,
      NULL,
      0,
      1.795625,
      1,
      0,
      0.595025,
      0,
      0.779144,
      0,
      NULL,
      1.269928,
      0,
      1,
      1.540728,
      0.834660,
      NULL,
      NULL,
      1.971222,
      3.251871,
      1.362038,
      0,
      0,
      0.336609,
      NULL,
      1,
      1,
      5,
      0,
      NULL,
      1,
      1.795903,
      4.687616,
      3,
      NULL,
      1,
      4,
      5,
      NULL,
      NULL,
      3.493943,
      3,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      2.952361,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.753589,
      2.237946,
      1.616197,
      NULL,
      0,
      NULL,
      0.375817,
      1,
      1.862881,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002384,
      2.372573,
      NULL,
      0.740656,
      NULL,
      NULL,
      0.417348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.010525,
      3,
      2.158608,
      0,
      NULL,
      1.298678,
      0,
      0.477442,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.563643,
      1.717185,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.173738,
      '23213',
      '1143',
      '',
      0.127667,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      4.514809,
      2.906797,
      2,
      NULL,
      2,
      1,
      NULL,
      1,
      2);
commit;
end;
/


