set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000796';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4030',
      '41101143',
      NULL,
      67.597869,
      NULL,
      7.838842,
      0,
      3,
      0,
      '212203',
      NULL,
      '10- 3-1979',
      27,
      2,
      NULL,
      NULL,
      1.171782,
      NULL,
      NULL,
      0.357689,
      3.751425,
      1.846222,
      1.776956,
      1,
      NULL,
      0,
      1.624247,
      0.689909,
      0.819351,
      1.315744,
      0,
      0.950492,
      5,
      0.534852,
      0.300728,
      1.409152,
      1,
      0,
      1,
      0,
      2.032627,
      1,
      0,
      1.102016,
      NULL,
      NULL,
      1.481667,
      NULL,
      NULL,
      NULL,
      0.749406,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016763,
      0,
      7,
      1.077835,
      1,
      1,
      1.655584,
      0.330118,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.149780,
      1,
      1,
      0,
      1.191794,
      0.374754,
      0.502062,
      1.492360,
      1.062003,
      1.506255,
      NULL,
      0,
      0,
      NULL,
      0.899445,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.313871,
      0.725106,
      0.029239,
      NULL,
      NULL,
      2.479288,
      0,
      5.941820,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      4,
      2.805207,
      NULL,
      2,
      1.093790,
      5,
      2.779711,
      NULL,
      4,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1.144677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1.123339,
      NULL,
      1.962116,
      1.978637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988709,
      0.638595,
      0.686840,
      1,
      1,
      NULL,
      2,
      0.415086,
      NULL,
      NULL,
      NULL,
      1.721180,
      0.797360,
      5.897452,
      NULL,
      NULL,
      0,
      0.882913,
      NULL,
      NULL,
      NULL,
      1,
      0.458478,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684618,
      0,
      3,
      3.607752,
      2.905556,
      3.360821,
      1,
      0.316839,
      3,
      1.110224,
      0.480555,
      NULL,
      NULL,
      NULL,
      0,
      1.295131,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '22440',
      '1441',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.323237,
      0.513098,
      4.556093,
      1,
      0.301204,
      3.181707,
      NULL,
      2.444685,
      2.692861);
commit;
end;
/


