set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '131',
      '02',
      21.019738,
      12.512157,
      '3424200',
      20,
      2,
      NULL,
      NULL,
      '240223',
      0.062164,
      '10-12-1991',
      15.173532,
      44.023942,
      0.109231,
      NULL,
      0.334485,
      NULL,
      0,
      NULL,
      0,
      0.580126,
      3.999321,
      3.275280,
      1.351818,
      1.393899,
      1.520352,
      0.136223,
      0,
      0.794227,
      1.741000,
      1,
      0.653373,
      0.377268,
      0,
      NULL,
      1.955218,
      1.162835,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.757204,
      0,
      1,
      0.514985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357201,
      NULL,
      NULL,
      0.722517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.439347,
      NULL,
      3.304174,
      0,
      6,
      1,
      0,
      1.083997,
      0.763067,
      0,
      1.374111,
      2.095165,
      0,
      3.188204,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      4.317147,
      NULL,
      NULL,
      1.846387,
      NULL,
      0.399847,
      4,
      1.793002,
      NULL,
      0.010843,
      4,
      3,
      3.411357,
      NULL,
      5,
      2,
      11,
      10,
      1,
      7,
      10.944781,
      5.628270,
      5,
      10.167973,
      7.083922,
      10.047928,
      10.117554,
      NULL,
      0,
      1.607045,
      NULL,
      NULL,
      1.207386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.737264,
      1,
      1,
      1,
      1.576460,
      1.611737,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.703053,
      NULL,
      2.839407,
      NULL,
      2,
      1.824856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.825655,
      1,
      1.535260,
      1.090109,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.166986,
      2.936630,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473287,
      1.007780,
      1,
      2,
      2.109096,
      3,
      2,
      NULL,
      2.922792,
      2,
      0,
      1,
      NULL,
      1.635609,
      1,
      1,
      0,
      1,
      0.783716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      '30234',
      NULL,
      0.867479,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


