set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22303042',
      7.927880,
      NULL,
      '1134313',
      12.746924,
      3,
      0,
      3,
      '321234',
      4,
      '10- 2-1995',
      NULL,
      NULL,
      1,
      NULL,
      0,
      3.762029,
      0,
      1.352466,
      0.928747,
      0.040659,
      3,
      3,
      0,
      1.902689,
      0.636637,
      0.885525,
      1.492468,
      0.255509,
      0,
      NULL,
      1.637324,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.644010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041188,
      1,
      NULL,
      0.030742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315854,
      0.421175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970492,
      0.926587,
      NULL,
      0.019246,
      1.887729,
      1,
      NULL,
      0.740103,
      1,
      0,
      0,
      1,
      1.578491,
      1,
      0.945711,
      NULL,
      0,
      NULL,
      0.057275,
      NULL,
      1,
      5,
      1.382162,
      1,
      0,
      0.797739,
      4.272776,
      NULL,
      1,
      0,
      NULL,
      1,
      1.918268,
      1,
      NULL,
      0.749711,
      2.912145,
      NULL,
      2.036949,
      2,
      3.232538,
      5,
      2,
      NULL,
      0.182744,
      0,
      0.490771,
      1,
      0,
      NULL,
      NULL,
      7,
      0.837174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.397784,
      0,
      NULL,
      0,
      0.751291,
      NULL,
      1.543885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.037075,
      NULL,
      NULL,
      NULL,
      NULL,
      0.680806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.174795,
      0,
      0.234427,
      NULL,
      0.794467,
      NULL,
      NULL,
      NULL,
      1.787406,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575752,
      1,
      0.983515,
      1,
      NULL,
      1.043099,
      NULL,
      NULL,
      1.129101,
      1,
      1.783491,
      0,
      0,
      NULL,
      1.568781,
      0,
      0.073537,
      0,
      0.547280,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00200',
      NULL,
      0.277865,
      '',
      '',
      '',
      3.140503,
      '3423',
      '',
      '',
      2.330502,
      0,
      NULL,
      4,
      1.064183,
      3,
      2.024887,
      1,
      NULL);
commit;
end;
/


