set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2404',
      '30004132',
      71.739875,
      38,
      '4432341',
      101,
      6,
      1.068830,
      NULL,
      '012202',
      5.499878,
      ' 8-16-1974',
      NULL,
      28,
      NULL,
      NULL,
      1.377716,
      1,
      2.699748,
      NULL,
      1,
      1,
      3,
      0,
      1,
      0,
      3.591271,
      0.935465,
      0,
      NULL,
      0.575779,
      NULL,
      2.157083,
      1.551142,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      2.006492,
      0,
      1,
      NULL,
      NULL,
      0.145603,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.399696,
      1.681185,
      0,
      0.961376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633716,
      1,
      NULL,
      NULL,
      0.293286,
      0,
      1.575849,
      0.503641,
      NULL,
      1,
      0,
      NULL,
      0.133326,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0.962003,
      5,
      1.403438,
      1.463048,
      0,
      0,
      NULL,
      3.318677,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.030355,
      2,
      NULL,
      NULL,
      9.479660,
      6.158082,
      1,
      NULL,
      NULL,
      5.517509,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458529,
      1.627478,
      0,
      1,
      0,
      1.436172,
      0,
      0.891963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162227,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.116394,
      2.441459,
      NULL,
      0.110233,
      5,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      4.083271,
      1.284571,
      0,
      NULL,
      0.266887,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812903,
      1.176468,
      1.570215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235998,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255687,
      NULL,
      3.394814,
      0.092449,
      0.046366,
      NULL,
      0,
      0.920713,
      1.120226,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398413,
      '33000',
      '01143',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '0021',
      NULL,
      NULL,
      4,
      1,
      0,
      3.535424,
      NULL,
      3,
      3,
      2.404456,
      1);
commit;
end;
/


