set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4330',
      '04222002',
      86,
      NULL,
      '4400330',
      NULL,
      5,
      2,
      NULL,
      NULL,
      4.134861,
      ' 9- 4-2000',
      NULL,
      52,
      1.465609,
      NULL,
      0.692922,
      1.412809,
      3.240675,
      0.136024,
      0,
      0.304613,
      1.584497,
      2.713716,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1.955728,
      1.810872,
      0.815272,
      1.339431,
      1.866632,
      0,
      1,
      0.510336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397495,
      0,
      1.128935,
      1.260164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.703539,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088694,
      1.608278,
      NULL,
      0.592619,
      0,
      0.269539,
      1,
      1,
      0.327133,
      1,
      0.222984,
      0,
      0.797144,
      NULL,
      1,
      1,
      1,
      0,
      1.550918,
      NULL,
      NULL,
      3.825063,
      2.655309,
      5,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.281396,
      NULL,
      0.321095,
      NULL,
      1,
      0,
      7.092147,
      0.499091,
      3,
      0,
      3,
      3.349066,
      2.305175,
      5.083712,
      2.263443,
      0.877347,
      NULL,
      NULL,
      9.048883,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771251,
      NULL,
      0,
      NULL,
      1.315720,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.226078,
      0,
      1,
      0,
      NULL,
      0,
      0.849676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.518652,
      0.685010,
      0.819907,
      2,
      3.077588,
      NULL,
      0.472039,
      0,
      NULL,
      1,
      0.592636,
      NULL,
      NULL,
      0.278488,
      1,
      NULL,
      0.274526,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.997679,
      '34032',
      '10022',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '0434',
      '32041',
      '',
      NULL,
      1,
      1,
      0.845039,
      NULL,
      NULL,
      2,
      0.215486,
      2.915183);
commit;
end;
/


