set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '4212022',
      6,
      3,
      2,
      2,
      '432441',
      3,
      ' 6-28-1989',
      49.157496,
      NULL,
      0,
      NULL,
      2,
      0.415263,
      3,
      0,
      1,
      0.903314,
      0,
      0.110363,
      0,
      0,
      3.884968,
      1.194445,
      1.562581,
      1,
      NULL,
      1,
      1,
      3.983996,
      0,
      0,
      0.354629,
      0.612887,
      NULL,
      0,
      NULL,
      1,
      3.134362,
      NULL,
      NULL,
      NULL,
      1.229588,
      NULL,
      NULL,
      6,
      1.505337,
      NULL,
      0.167088,
      0.485306,
      0.889024,
      3,
      NULL,
      3,
      1,
      NULL,
      0.241592,
      0,
      0,
      1,
      0.393179,
      NULL,
      0,
      0.048011,
      2.635898,
      0,
      0.149915,
      2,
      0,
      1,
      1.746394,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.781518,
      NULL,
      1,
      2,
      1.139778,
      4,
      0,
      1,
      1,
      1,
      1.953733,
      NULL,
      3.876934,
      1,
      1.736875,
      1,
      1,
      0.801012,
      NULL,
      0,
      2.676689,
      1.221683,
      1.628386,
      1.092358,
      2,
      1,
      1,
      3.722824,
      1.441017,
      2.098131,
      NULL,
      NULL,
      1.921771,
      4,
      2,
      NULL,
      4,
      1,
      2.488050,
      0.174281,
      9,
      5,
      1.256464,
      2.885020,
      5,
      1,
      4,
      3.861222,
      NULL,
      1.105578,
      1.599915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.995063,
      1.666986,
      1,
      1.145003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101379,
      NULL,
      0.881772,
      2.473197,
      2.336991,
      0,
      3.769700,
      3,
      0.170412,
      1,
      NULL,
      1.451346,
      NULL,
      1.218027,
      NULL,
      NULL,
      NULL,
      0.295655,
      1,
      7,
      NULL,
      0,
      NULL,
      1.551842,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.681453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.418082,
      3.613362,
      NULL,
      NULL,
      3.437130,
      1,
      1.981732,
      0.493652,
      NULL,
      1.611434,
      NULL,
      0.806067,
      0,
      0,
      1,
      1.405229,
      0.531870,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.964338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '40004',
      NULL,
      '',
      3.107035,
      '21400',
      NULL,
      '',
      3,
      '2023',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


