set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34',
      NULL,
      6.663923,
      '3010030',
      7,
      0,
      2,
      3,
      '411344',
      0,
      ' 1-23-1975',
      19,
      66,
      0,
      NULL,
      2,
      NULL,
      3.280785,
      0.818786,
      0,
      3.639287,
      0.290409,
      1,
      NULL,
      NULL,
      0.926366,
      0,
      NULL,
      1.412348,
      NULL,
      4.717275,
      NULL,
      NULL,
      NULL,
      3.901085,
      1.463726,
      1,
      6,
      0,
      2.746612,
      0,
      NULL,
      0.936206,
      NULL,
      NULL,
      1.055954,
      NULL,
      NULL,
      NULL,
      0.225933,
      NULL,
      NULL,
      NULL,
      0.276856,
      3,
      0,
      1.343985,
      1.818916,
      0,
      0,
      NULL,
      2.467064,
      2.754391,
      1,
      2,
      1,
      0.688559,
      0,
      0.057053,
      0.989132,
      9.966335,
      0,
      2,
      1.556672,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.512387,
      1.681652,
      1,
      1.514693,
      0,
      1.885509,
      NULL,
      NULL,
      0.789657,
      NULL,
      1.682549,
      0,
      0.764957,
      0.980466,
      NULL,
      NULL,
      1.096037,
      1.464264,
      1,
      0.445395,
      1.171185,
      NULL,
      NULL,
      0,
      2.314920,
      0,
      1.021633,
      5,
      3,
      1,
      2,
      2.833197,
      1.642226,
      3.588029,
      NULL,
      2.414596,
      7,
      4,
      7.024173,
      5.022106,
      5,
      1.715810,
      6.500487,
      NULL,
      3,
      0,
      0.472118,
      2.038791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.046359,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      0.866426,
      0.762155,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2.793266,
      0.833875,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.995236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      1.192201,
      1.487021,
      0,
      NULL,
      0.129767,
      3,
      NULL,
      0.344273,
      1,
      1.955912,
      0,
      0.866161,
      1.651969,
      1.589434,
      NULL,
      1.861232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.945541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.916861,
      '04321',
      NULL,
      '',
      2,
      '40213',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


