set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      NULL,
      27.651623,
      NULL,
      '4303132',
      21,
      6,
      NULL,
      0,
      '323420',
      3.572468,
      NULL,
      1,
      39,
      NULL,
      NULL,
      1.819897,
      1.908624,
      3,
      0.022408,
      0,
      1,
      NULL,
      0,
      1.507032,
      0.477620,
      3.410725,
      NULL,
      0,
      0,
      1.015845,
      2.386014,
      2,
      1.978748,
      NULL,
      3.068976,
      1,
      1.821484,
      0,
      1,
      5.349631,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.426150,
      NULL,
      NULL,
      2.698571,
      1.908042,
      0,
      3.809943,
      0,
      NULL,
      2.889555,
      3.312730,
      NULL,
      NULL,
      2,
      1,
      1.136842,
      NULL,
      0,
      NULL,
      6,
      1.306454,
      NULL,
      8,
      0,
      0,
      1.825279,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.698774,
      0.827824,
      0,
      1,
      1,
      1,
      1.089427,
      0.679197,
      0,
      1,
      0.347964,
      0,
      NULL,
      0,
      0,
      1.834280,
      1.858131,
      1.153346,
      0.171013,
      NULL,
      0,
      1.610406,
      1.162280,
      0,
      NULL,
      4.143280,
      1.339594,
      1,
      NULL,
      0.672968,
      1,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.230440,
      0,
      1.159959,
      1,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1.027790,
      NULL,
      1.826295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.479490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.929016,
      1.124626,
      NULL,
      1,
      NULL,
      0,
      0.589497,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082951,
      1.983805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.082903,
      0.236893,
      1,
      2,
      1,
      1.664982,
      2.797168,
      0.029437,
      NULL,
      0,
      1.553237,
      1.119068,
      0.695416,
      1,
      1,
      0.722967,
      0,
      1,
      1.550312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '24420',
      '',
      '',
      NULL,
      '2124',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


