set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      '13',
      36.853796,
      NULL,
      '1124301',
      39.741577,
      NULL,
      2.448259,
      1,
      NULL,
      1.557430,
      NULL,
      10,
      139.511005,
      NULL,
      NULL,
      2,
      0,
      0.546808,
      1.357020,
      0,
      1.879766,
      1,
      0,
      1.002937,
      NULL,
      1,
      0,
      NULL,
      1,
      0.382898,
      2.948196,
      0,
      0,
      1.099266,
      5,
      NULL,
      0.662708,
      2.745792,
      0,
      0.652528,
      0,
      2,
      1,
      NULL,
      NULL,
      0.593028,
      NULL,
      NULL,
      2.066485,
      0.365837,
      4,
      3.602210,
      1,
      0,
      3,
      NULL,
      2.432674,
      2.527363,
      NULL,
      2.253042,
      3.127541,
      3,
      1.258321,
      1,
      0,
      0.469815,
      0,
      NULL,
      0,
      3.657419,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1.348907,
      NULL,
      NULL,
      NULL,
      0,
      1.652051,
      0.823610,
      1.727949,
      0.678938,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0.316258,
      0.148930,
      0.329467,
      0.704030,
      NULL,
      1.617721,
      1.024793,
      NULL,
      0.368819,
      1.525127,
      1,
      NULL,
      1,
      4,
      NULL,
      NULL,
      6.558609,
      0,
      2,
      1.539147,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      5,
      NULL,
      3,
      7,
      1,
      7.875729,
      NULL,
      NULL,
      0,
      5.533713,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.305004,
      1,
      1,
      1,
      0,
      1.688282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.626072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      4.346932,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.437970,
      1.564112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.813236,
      1,
      NULL,
      1.882423,
      1,
      0.914616,
      NULL,
      1.439443,
      3,
      NULL,
      1,
      NULL,
      0.521136,
      1,
      NULL,
      0.763854,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.681846,
      '01404',
      '',
      NULL,
      3.946919,
      '44134',
      '',
      NULL,
      NULL,
      '1042',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


