set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '434',
      '32',
      16.310984,
      2,
      '3321101',
      NULL,
      5,
      2,
      3,
      '240202',
      4,
      NULL,
      8.638664,
      50,
      0,
      NULL,
      0.033426,
      0.826035,
      NULL,
      1.603379,
      0,
      2,
      1,
      0,
      1,
      0,
      5.471284,
      0.966323,
      1.505930,
      NULL,
      0,
      NULL,
      5.667663,
      0,
      NULL,
      0,
      1.660251,
      0,
      2.085855,
      1,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.119458,
      3.723425,
      3.259633,
      3.336174,
      1.081222,
      NULL,
      3.300601,
      0,
      1.975744,
      1.127903,
      0.038469,
      2,
      0.714406,
      2.811489,
      1.745820,
      1,
      0,
      1.886522,
      0.323668,
      NULL,
      1,
      5.398501,
      3,
      1,
      NULL,
      0.928564,
      1,
      NULL,
      NULL,
      0.416469,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      5,
      1.080298,
      0.443823,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0.222530,
      0.906249,
      0.596594,
      0,
      NULL,
      0.323570,
      NULL,
      1.825183,
      1.100886,
      0.202958,
      0.632910,
      1.896421,
      2.862372,
      NULL,
      1,
      5,
      0,
      NULL,
      1.442286,
      3.814901,
      1.800500,
      3,
      0,
      0.570584,
      0,
      2.361288,
      3.795721,
      0.120187,
      NULL,
      1.955289,
      0.124397,
      7,
      3.969775,
      0,
      3,
      0.261365,
      1.505612,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795697,
      0,
      1,
      1,
      0.419703,
      NULL,
      0.473952,
      0.349351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.171972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.530106,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.431204,
      NULL,
      5.745804,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.467510,
      NULL,
      0,
      1.620597,
      1,
      2,
      1.592379,
      2.735979,
      0.495624,
      1.020562,
      1.190685,
      NULL,
      NULL,
      0,
      NULL,
      1.660000,
      0,
      1,
      0,
      0.391822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.947715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.625447,
      '00300',
      '',
      '',
      2.861720,
      '23143',
      '',
      NULL,
      3.048249,
      '3220',
      '',
      '',
      0.163936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


