set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '120',
      '43',
      44.640195,
      27,
      '0032100',
      NULL,
      2,
      0,
      0,
      '330142',
      0,
      '11- 5-1974',
      26,
      33.790151,
      0.799874,
      NULL,
      3,
      1,
      1.278310,
      1,
      1.197620,
      3.418774,
      0.454677,
      0,
      3,
      0,
      5,
      NULL,
      0.655960,
      NULL,
      0.043125,
      6,
      NULL,
      NULL,
      1.930866,
      0.239648,
      0.299978,
      1.459008,
      0.833230,
      0,
      2,
      0.415374,
      0,
      0.500017,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.104751,
      NULL,
      NULL,
      1.586295,
      1,
      1,
      0.283274,
      0.156974,
      0,
      3.761639,
      NULL,
      NULL,
      2,
      NULL,
      0.700805,
      NULL,
      1.835585,
      0.931270,
      0,
      0,
      NULL,
      0.904057,
      1,
      NULL,
      1.050605,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187153,
      0.846769,
      1,
      2.530910,
      NULL,
      0.395679,
      NULL,
      1.549398,
      0,
      1,
      NULL,
      1.912593,
      1,
      1,
      NULL,
      NULL,
      1,
      1.169655,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1.767894,
      NULL,
      6,
      NULL,
      0,
      1.774611,
      3,
      1,
      1,
      0.151385,
      0,
      0.993488,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      2.323993,
      2,
      1,
      2,
      2.070576,
      NULL,
      0,
      7.314048,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0.637089,
      0,
      1,
      0.980784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.971303,
      3.675649,
      NULL,
      0.618084,
      1,
      NULL,
      0.904600,
      0,
      1.254024,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      6,
      0.969465,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.709587,
      1.622900,
      1.739037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583210,
      3,
      NULL,
      0.398702,
      0.534972,
      NULL,
      NULL,
      1,
      0.152694,
      1,
      0.895137,
      1.641817,
      1,
      0,
      NULL,
      0,
      NULL,
      0.981184,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      NULL,
      2.982522,
      '13421',
      '',
      '',
      0,
      '2012',
      '',
      NULL,
      3.245513,
      NULL,
      NULL,
      NULL,
      2.350827,
      1,
      NULL,
      2.205968,
      NULL);
commit;
end;
/


