set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '41232430',
      45,
      9,
      '1030424',
      73.358298,
      0,
      3,
      NULL,
      '143033',
      NULL,
      ' 1- 0-1978',
      31.020033,
      48,
      NULL,
      NULL,
      NULL,
      0.219816,
      1,
      0.203537,
      1.538223,
      0.871963,
      NULL,
      0.196542,
      3,
      NULL,
      0.911196,
      1.703848,
      1.407804,
      0.966764,
      0.274515,
      NULL,
      2.943626,
      0.063470,
      0.004364,
      1,
      NULL,
      1.790017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.291520,
      0,
      1,
      NULL,
      1.263440,
      0,
      2.861525,
      1.910291,
      NULL,
      1.907051,
      3.044037,
      1,
      0,
      NULL,
      1,
      1.283387,
      1,
      1,
      1,
      0.556668,
      1,
      NULL,
      6.175219,
      1,
      0,
      0.579605,
      NULL,
      NULL,
      NULL,
      0.736836,
      NULL,
      NULL,
      1.697116,
      NULL,
      1,
      5,
      4.213348,
      NULL,
      1.668779,
      0,
      0.901209,
      0.042562,
      0.739564,
      1,
      0.207132,
      0,
      1,
      1,
      1,
      1.449371,
      NULL,
      NULL,
      1.039574,
      2,
      1.104738,
      1.801150,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.395126,
      2,
      2.235000,
      0,
      0.022330,
      4.780726,
      4.683218,
      5,
      5,
      0.146881,
      0.619601,
      1,
      NULL,
      3.582610,
      0,
      2,
      NULL,
      0,
      1.390240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417924,
      NULL,
      NULL,
      0,
      1.021085,
      0.458167,
      0.809669,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067228,
      NULL,
      NULL,
      NULL,
      NULL,
      0.258145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.909514,
      0,
      4.032456,
      NULL,
      1.121098,
      0,
      1.529953,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.197787,
      0.130719,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.521102,
      2.105675,
      2.857293,
      1.656608,
      0.504077,
      NULL,
      1,
      1.831900,
      NULL,
      1.688557,
      0.114266,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.177802,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2.404917,
      '3140',
      '',
      '',
      NULL,
      3.428542,
      0.110645,
      1.292424,
      1.788344,
      0,
      1,
      NULL,
      NULL);
commit;
end;
/


