set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '440',
      '01031340',
      0,
      2.988630,
      '4104134',
      15,
      NULL,
      1.543393,
      0,
      '124441',
      3.789824,
      '11-11-1979',
      NULL,
      85.525481,
      1,
      NULL,
      NULL,
      1.547078,
      0.225999,
      1.506800,
      0,
      0,
      1,
      0,
      3,
      0,
      0.431703,
      0,
      1,
      0.448525,
      1.918770,
      1,
      1.080503,
      0.283011,
      3,
      NULL,
      1,
      1,
      1.100529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.423631,
      5,
      NULL,
      0.048694,
      1,
      0,
      NULL,
      2,
      1.380482,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      3,
      1,
      1,
      NULL,
      1,
      NULL,
      0.116360,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.010041,
      NULL,
      NULL,
      0.628878,
      1,
      0.695886,
      5,
      1.204905,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1.181281,
      0.661415,
      1.680116,
      1.070116,
      0.295153,
      0.801877,
      1.425484,
      NULL,
      NULL,
      1.113441,
      1,
      1,
      1,
      1,
      1.019136,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      0.932846,
      0,
      1.207086,
      NULL,
      2,
      1.628857,
      NULL,
      0,
      7,
      6,
      2.678127,
      0,
      2.420458,
      2.285812,
      0,
      1,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1.835189,
      0.050703,
      1.589986,
      1.621068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.343926,
      1.369505,
      1,
      6.275109,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.443426,
      NULL,
      1.084695,
      1.358711,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.930330,
      0.091979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.725507,
      NULL,
      2.339129,
      1.807315,
      2.631641,
      NULL,
      3,
      1.090547,
      0,
      0.895763,
      0.818538,
      0.103132,
      0,
      0,
      1,
      1.894791,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '42300',
      NULL,
      '',
      2,
      '31341',
      '',
      '',
      1,
      '0034',
      '',
      '',
      4.111389,
      NULL,
      NULL,
      2,
      3,
      1.605926,
      0,
      NULL,
      3);
commit;
end;
/


