set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '224',
      '21024423',
      33,
      0.114846,
      '4110002',
      39,
      NULL,
      1,
      0,
      '320342',
      0.664208,
      NULL,
      55,
      55,
      NULL,
      NULL,
      2,
      0,
      0.966517,
      0,
      NULL,
      0.142316,
      NULL,
      NULL,
      0.074667,
      0.423233,
      3.358196,
      NULL,
      0,
      0.970286,
      1.216835,
      NULL,
      NULL,
      1,
      0.036315,
      1,
      1,
      0.321049,
      2.193664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015682,
      0,
      0.211603,
      NULL,
      1.970012,
      1.744712,
      0,
      1.650509,
      0,
      2,
      1,
      3.524140,
      NULL,
      0.029059,
      1.377539,
      1.573688,
      1,
      NULL,
      1.255040,
      NULL,
      1.352004,
      0.167016,
      6.044214,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.503632,
      1.576072,
      NULL,
      2.993061,
      1.986712,
      1.966729,
      1.230906,
      0,
      0,
      NULL,
      NULL,
      1.047128,
      1.178766,
      0,
      NULL,
      0,
      1,
      1.301976,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1.748813,
      1,
      4.985095,
      1.742915,
      NULL,
      2,
      2.083831,
      3.813869,
      0,
      0,
      NULL,
      NULL,
      1,
      3.589223,
      2,
      5.352283,
      3.682104,
      NULL,
      9.713040,
      0.778679,
      2.411752,
      7,
      1,
      1,
      5,
      2,
      1.612144,
      0,
      6,
      0.633267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0.482463,
      0.589123,
      NULL,
      1.577334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006861,
      0.202642,
      0,
      1,
      0,
      4,
      2,
      3.188653,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.271828,
      2.985192,
      NULL,
      NULL,
      1.258816,
      NULL,
      NULL,
      NULL,
      0.737606,
      7,
      0.575568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012836,
      0,
      0.765331,
      0.053447,
      NULL,
      NULL,
      0,
      0,
      0.068759,
      1,
      0.355396,
      1.424391,
      NULL,
      1,
      0,
      NULL,
      1,
      1.242336,
      0.578460,
      0.975187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.894739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '',
      '',
      3,
      '33010',
      '',
      '',
      2,
      '3234',
      NULL,
      '',
      1.171168,
      1.192220,
      1.804602,
      0.839763,
      NULL,
      0,
      2.900768,
      1,
      1);
commit;
end;
/


