set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '220',
      '44101201',
      39,
      52,
      NULL,
      48.377655,
      3,
      2.370755,
      2,
      '340020',
      5.407165,
      ' 6-28-1983',
      5,
      56.812187,
      1,
      NULL,
      2.965097,
      0.331862,
      3.128785,
      1.887713,
      0,
      2.857688,
      1,
      1,
      NULL,
      0.784263,
      NULL,
      NULL,
      1,
      1.148203,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1.856739,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.968112,
      NULL,
      3.840924,
      0.426317,
      0,
      2.043555,
      0,
      2,
      0.407127,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0.312596,
      0,
      0,
      NULL,
      0.157695,
      0,
      1,
      0.132455,
      NULL,
      1,
      1.300956,
      1.252313,
      NULL,
      NULL,
      0.182920,
      NULL,
      NULL,
      1,
      0.011495,
      NULL,
      5.778950,
      4.978910,
      0.382735,
      0,
      0.654925,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.038298,
      1,
      0,
      NULL,
      1.292836,
      NULL,
      0,
      NULL,
      0.399234,
      1,
      1,
      4,
      3.408316,
      0,
      1,
      NULL,
      NULL,
      0.301466,
      4,
      NULL,
      1.639305,
      NULL,
      5,
      0.220866,
      1.297995,
      NULL,
      1.827680,
      6,
      NULL,
      5.965839,
      2,
      NULL,
      0,
      3,
      3.174819,
      0.862792,
      1,
      NULL,
      0.034160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.126172,
      1,
      1,
      NULL,
      1,
      0,
      1.491533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.047047,
      1,
      2,
      1,
      1.141501,
      3,
      0.273291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.955635,
      NULL,
      6.122410,
      3,
      0.555236,
      1,
      1.276464,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406841,
      1.840625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646433,
      NULL,
      1,
      0,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.219416,
      0.204165,
      1.301372,
      0.755393,
      1.675550,
      1.642029,
      0,
      1.744739,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.853860,
      '22304',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      3,
      '3242',
      '',
      '',
      4,
      NULL,
      NULL,
      4,
      NULL,
      0.364832,
      1.041959,
      0.345582,
      NULL);
commit;
end;
/


