set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '01000020',
      25,
      NULL,
      NULL,
      52,
      5,
      3.735714,
      0,
      '133434',
      0,
      ' 0-13-1993',
      NULL,
      15,
      0.151084,
      NULL,
      NULL,
      0.425763,
      0.809264,
      0.810747,
      1.243859,
      NULL,
      0.293745,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0.120668,
      0,
      2.739972,
      1.160415,
      4,
      0.168536,
      0.043913,
      0.872386,
      1.572889,
      0,
      3.087857,
      1.177225,
      1,
      0,
      NULL,
      NULL,
      0.805842,
      NULL,
      NULL,
      NULL,
      1.892609,
      4.218356,
      0,
      0.145128,
      1,
      2.251581,
      1,
      NULL,
      0.862628,
      0.832903,
      NULL,
      1.811137,
      NULL,
      0,
      1,
      2.661133,
      1,
      NULL,
      1.827339,
      0,
      0.039301,
      4,
      1,
      2,
      0.907479,
      0.504537,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.736970,
      1.511482,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.146737,
      0,
      1.193054,
      0.931277,
      0.875375,
      0,
      1.631607,
      NULL,
      1,
      4,
      1.928653,
      1.191863,
      0.918678,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4.514206,
      1,
      2,
      2,
      2,
      5,
      NULL,
      7.194723,
      NULL,
      0,
      2,
      2,
      NULL,
      2,
      1,
      0,
      0.745487,
      6.158687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615769,
      1.145715,
      1,
      1,
      NULL,
      1.548220,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.384032,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0.334705,
      2.536869,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.401910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.533726,
      NULL,
      1.581143,
      0,
      0,
      1.574717,
      2.296211,
      1.851157,
      NULL,
      NULL,
      0.695670,
      0,
      1,
      0,
      1,
      1.695161,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '',
      '',
      NULL,
      '40413',
      '',
      NULL,
      0,
      '1443',
      '',
      '',
      3,
      1.908913,
      0,
      2.478694,
      1.854503,
      3,
      0,
      1,
      0);
commit;
end;
/


