set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '431',
      '02304302',
      9,
      45.905690,
      '0310333',
      99,
      5,
      1.015072,
      2,
      '421042',
      0.530005,
      ' 8-11-2000',
      24.145958,
      60,
      NULL,
      NULL,
      0.616901,
      NULL,
      0,
      1.533841,
      1,
      0.297996,
      NULL,
      0.581159,
      0.246758,
      0,
      2,
      0.914380,
      1.085559,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0.773652,
      2,
      0,
      2.463205,
      0.202524,
      2.181128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.380861,
      3,
      2,
      0.665751,
      0,
      0,
      NULL,
      0.968464,
      1.746095,
      0,
      NULL,
      NULL,
      NULL,
      0.267312,
      NULL,
      3,
      0.734995,
      1,
      0.503163,
      1,
      1.362900,
      6.292010,
      1,
      0,
      1.165985,
      0.214063,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.619082,
      1.163904,
      1,
      NULL,
      4.569686,
      1,
      NULL,
      1,
      0,
      0.208525,
      1.114112,
      NULL,
      1,
      1.929162,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.100092,
      1.538834,
      1.856017,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.092641,
      0.647282,
      0.373191,
      1,
      2.163229,
      5.042065,
      5,
      NULL,
      2,
      1.297181,
      7.735601,
      3,
      5,
      1,
      4.335981,
      3.638722,
      1.276212,
      0,
      5.514951,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.278346,
      1.843709,
      1,
      1,
      1,
      0,
      0.071087,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040117,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.163169,
      0.615873,
      0.986430,
      3.239500,
      NULL,
      2.287401,
      0,
      NULL,
      NULL,
      NULL,
      2.235751,
      0.588456,
      0.140545,
      NULL,
      1.869280,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.209458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036888,
      0.943324,
      NULL,
      1,
      2.984319,
      1.249707,
      0,
      2.740628,
      NULL,
      3.324823,
      3,
      1,
      1.554253,
      NULL,
      1.749324,
      1.440301,
      1,
      0.554965,
      0.888268,
      1.121712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.051479,
      '41022',
      '',
      NULL,
      NULL,
      '34224',
      '',
      '',
      1.665432,
      '3120',
      NULL,
      '',
      1.588928,
      1,
      NULL,
      4.378624,
      NULL,
      3.124173,
      NULL,
      NULL,
      2);
commit;
end;
/


