set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '323',
      '40023042',
      18.647460,
      NULL,
      '4140101',
      153,
      4,
      NULL,
      0,
      '432333',
      0,
      NULL,
      43,
      NULL,
      1,
      NULL,
      1.542110,
      1.143685,
      2.477379,
      0,
      0.020007,
      1.064971,
      0.330782,
      0,
      NULL,
      NULL,
      0,
      1.018093,
      0.847885,
      NULL,
      0,
      0.334167,
      0.478277,
      1,
      2,
      1.316206,
      0,
      1,
      1,
      1,
      2.363133,
      1.419348,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.464916,
      0,
      NULL,
      3.762041,
      0,
      1,
      NULL,
      0,
      2.546200,
      0,
      0,
      0.006177,
      NULL,
      0,
      0.785705,
      0.242028,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.838111,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.700738,
      0.580957,
      3,
      0,
      NULL,
      1,
      0.395087,
      0.990446,
      NULL,
      0,
      1.107692,
      1,
      0,
      0,
      1.642650,
      0.619303,
      1.548487,
      NULL,
      1.201497,
      4.870367,
      1,
      NULL,
      0.063194,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      3,
      1,
      3.782726,
      4,
      NULL,
      4,
      1.419614,
      NULL,
      2,
      1,
      1.854192,
      NULL,
      1.117404,
      1,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.253542,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641202,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5.313478,
      1,
      6,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.684193,
      0.780711,
      1.003427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.793901,
      NULL,
      0,
      0.600243,
      3,
      1,
      1,
      0.578504,
      1,
      0.175790,
      1.432894,
      0.116230,
      0.150334,
      1,
      NULL,
      0,
      NULL,
      1,
      1.657791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.311041,
      '32214',
      '',
      NULL,
      2,
      NULL,
      NULL,
      '',
      1,
      '2231',
      '',
      '',
      3,
      0.721074,
      NULL,
      0.323241,
      NULL,
      3.203212,
      NULL,
      NULL,
      1.576032);
commit;
end;
/


