set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '212',
      '10012331',
      28,
      28,
      '0432120',
      3,
      0,
      3,
      0,
      '123024',
      4.768009,
      ' 1-17-1988',
      24.464148,
      5.479577,
      1,
      NULL,
      0,
      1.887408,
      2.694378,
      NULL,
      0,
      NULL,
      0.872483,
      1,
      0.168969,
      0.749514,
      0,
      1.001655,
      1.281460,
      0,
      NULL,
      2,
      4.742796,
      0,
      NULL,
      0,
      1.192835,
      1,
      1.317057,
      0,
      NULL,
      0.556149,
      3.706687,
      1.087887,
      NULL,
      NULL,
      1.263948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.930544,
      1,
      NULL,
      0,
      2,
      2,
      0,
      1,
      0.149088,
      3.459458,
      0,
      1.261840,
      2.897361,
      NULL,
      0.636819,
      0,
      NULL,
      1.932472,
      4,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0.866352,
      NULL,
      NULL,
      0.632860,
      0,
      0.131963,
      2,
      4,
      0,
      1.713654,
      0.278378,
      0,
      NULL,
      0,
      0.096237,
      0,
      1.733566,
      NULL,
      0,
      1.022126,
      1,
      0.084935,
      NULL,
      NULL,
      NULL,
      1.574275,
      0,
      NULL,
      0.187531,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.319427,
      NULL,
      NULL,
      4.111348,
      3.964338,
      5,
      3.306633,
      NULL,
      1.077562,
      4,
      7,
      4,
      1,
      1,
      1,
      1.171021,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113515,
      0,
      0,
      0,
      1,
      1,
      1.766210,
      0.610157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920004,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.529194,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      6.695738,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.882143,
      1,
      1.302611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      1.368329,
      1,
      NULL,
      NULL,
      1.670721,
      NULL,
      3,
      0.755473,
      NULL,
      NULL,
      0.568631,
      0,
      1,
      1.957944,
      0.758152,
      0.375112,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '43142',
      '',
      '',
      0,
      '30211',
      '',
      '',
      NULL,
      '1042',
      '',
      '',
      4.816183,
      1,
      1,
      1,
      2.822329,
      1,
      3.730749,
      1.964739,
      3.140906);
commit;
end;
/


