set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3104',
      '44444344',
      46.813588,
      NULL,
      '2214432',
      4.112514,
      0,
      0,
      NULL,
      '241304',
      1,
      '11-25-2001',
      5,
      6.846321,
      0.125084,
      NULL,
      0,
      NULL,
      3,
      0.018895,
      NULL,
      1.923688,
      NULL,
      1.002837,
      2.833458,
      1.117885,
      1,
      0,
      NULL,
      0,
      0.962670,
      NULL,
      0,
      0.514888,
      NULL,
      0.983789,
      0.047247,
      NULL,
      3,
      1,
      1,
      0.074787,
      NULL,
      1.557166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.252747,
      1,
      NULL,
      1,
      1.727408,
      1.138236,
      NULL,
      2.101154,
      NULL,
      1,
      1.790651,
      NULL,
      1.222211,
      0,
      1.157648,
      0.386694,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      2,
      0.666509,
      0.787567,
      NULL,
      NULL,
      0.298479,
      NULL,
      NULL,
      1.890538,
      0,
      0,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.377466,
      1.923519,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      1.759302,
      0.871261,
      NULL,
      1,
      1.528435,
      1,
      0.699137,
      1,
      1,
      NULL,
      1.807921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.791820,
      NULL,
      0.032803,
      3.287172,
      2.059275,
      5,
      6,
      0,
      1,
      2.586520,
      1,
      2.184115,
      NULL,
      3.685176,
      NULL,
      0,
      9.441146,
      0.539925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935360,
      1.298886,
      1,
      1,
      0.251980,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.317881,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.258564,
      NULL,
      NULL,
      2.134073,
      1,
      NULL,
      0.080212,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.316438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      1,
      1.362448,
      0.866773,
      0,
      NULL,
      NULL,
      1,
      0.767128,
      1,
      NULL,
      1.804812,
      0.181716,
      NULL,
      1.623453,
      1.371266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.345769,
      '22412',
      '',
      '',
      NULL,
      '33332',
      NULL,
      '',
      NULL,
      '1322',
      '',
      NULL,
      2.151696,
      3,
      NULL,
      3,
      0,
      NULL,
      3,
      0.029769,
      2.338534);
commit;
end;
/


