set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1431',
      NULL,
      49,
      16,
      '3001410',
      185.378474,
      3,
      NULL,
      1,
      '330303',
      4.009579,
      ' 7-10-1980',
      31.426544,
      34,
      1.554848,
      NULL,
      0.945786,
      NULL,
      0.886872,
      0,
      1.521253,
      0,
      NULL,
      NULL,
      2.353067,
      1.089579,
      3.080432,
      0,
      1.875725,
      NULL,
      NULL,
      3.460953,
      4,
      1.013697,
      1,
      2,
      NULL,
      0,
      4.979035,
      0,
      NULL,
      1.699994,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      3.447336,
      0,
      NULL,
      NULL,
      1.284336,
      0.144157,
      3,
      3,
      2,
      2.253140,
      0.575548,
      1,
      NULL,
      NULL,
      NULL,
      0.979073,
      1,
      0.704259,
      0,
      5,
      4.751285,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.063055,
      1.734958,
      1,
      5,
      4,
      NULL,
      1,
      1,
      1,
      1.453104,
      0.456940,
      NULL,
      1,
      1,
      NULL,
      0.421547,
      1.813313,
      0.591669,
      1,
      NULL,
      1.648731,
      NULL,
      0,
      1.784095,
      1,
      3.687117,
      5.752064,
      1.329966,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      1,
      NULL,
      2.718439,
      0,
      NULL,
      4.538963,
      7,
      0.189973,
      4.186094,
      1,
      0,
      6,
      5.053596,
      1,
      1,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.972318,
      1.645234,
      1,
      NULL,
      0.561659,
      NULL,
      1.276362,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.688238,
      0,
      NULL,
      NULL,
      NULL,
      4.793031,
      0.269237,
      7.776796,
      1.462634,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.204285,
      NULL,
      0.796815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161720,
      0.687351,
      0,
      0,
      0,
      0,
      0,
      3,
      0.064333,
      3.194674,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.044721,
      0.468304,
      1.399651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '42114',
      '',
      NULL,
      NULL,
      '10134',
      '',
      '',
      2.733171,
      '2403',
      '',
      '',
      4.557054,
      NULL,
      NULL,
      2.548943,
      2,
      NULL,
      NULL,
      3,
      NULL);
commit;
end;
/


