set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0241',
      '11343142',
      63.548915,
      5.299343,
      '1031414',
      NULL,
      4,
      NULL,
      0,
      '421200',
      3,
      ' 8- 4-1983',
      11.484288,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.461532,
      3.232824,
      NULL,
      1.045751,
      0.506550,
      3,
      1,
      0.921758,
      0.759149,
      1,
      NULL,
      0.930856,
      3,
      3.797281,
      1,
      1,
      3,
      NULL,
      NULL,
      2.566866,
      0,
      3,
      0,
      0,
      1.215607,
      NULL,
      NULL,
      0.803341,
      NULL,
      NULL,
      6.533914,
      NULL,
      6.588619,
      3.464882,
      1.741669,
      1.429233,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      1.859035,
      0,
      3,
      1,
      1.601020,
      1,
      0,
      1,
      2,
      1,
      2,
      NULL,
      0.721812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.584021,
      4,
      0.460158,
      1.020061,
      0,
      1,
      1,
      0.390332,
      1.416210,
      NULL,
      0.618553,
      0.785375,
      1.539884,
      0.501530,
      1,
      NULL,
      1.463409,
      NULL,
      0,
      5.625017,
      1.761903,
      0,
      0,
      3.074242,
      NULL,
      1,
      1.986984,
      0,
      0.200513,
      1,
      4.991040,
      1,
      2.703826,
      NULL,
      0,
      4.320663,
      7,
      1,
      NULL,
      NULL,
      1.157284,
      5,
      6.614530,
      1.821410,
      NULL,
      1.629430,
      0,
      0.402264,
      NULL,
      1,
      1.346729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.992102,
      1,
      0,
      1,
      0,
      0,
      0.353530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      1.308495,
      NULL,
      NULL,
      NULL,
      NULL,
      1.049787,
      6,
      5,
      0,
      1,
      0.632258,
      NULL,
      NULL,
      NULL,
      0.329407,
      5,
      0.487535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948307,
      1.737406,
      0.666670,
      2,
      NULL,
      1,
      NULL,
      1.699364,
      NULL,
      NULL,
      0,
      0.517529,
      NULL,
      NULL,
      0,
      0.519636,
      NULL,
      1,
      0.829644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '32324',
      '',
      NULL,
      0,
      '03312',
      '',
      '',
      3.028256,
      '2424',
      NULL,
      '',
      3.402417,
      0,
      0.145526,
      1,
      1,
      0,
      2,
      3.595823,
      2);
commit;
end;
/


