set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1132',
      NULL,
      NULL,
      NULL,
      '1222412',
      NULL,
      0,
      3.425728,
      NULL,
      '042042',
      2,
      '11- 3-1999',
      17.596214,
      50.558329,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0.575592,
      0.003956,
      NULL,
      1.922865,
      NULL,
      NULL,
      0.418798,
      1.394253,
      1.453477,
      0.512864,
      0,
      NULL,
      NULL,
      4.216410,
      NULL,
      0,
      1.225661,
      NULL,
      1,
      3,
      1,
      2,
      0,
      NULL,
      NULL,
      1.754957,
      NULL,
      NULL,
      5,
      NULL,
      2.806896,
      3.685512,
      1,
      1,
      1.554964,
      0,
      0,
      NULL,
      2,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1.337786,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.594064,
      NULL,
      NULL,
      0.175868,
      NULL,
      NULL,
      0,
      1,
      0.319473,
      5,
      NULL,
      0.809846,
      1,
      1.127770,
      1,
      NULL,
      NULL,
      0.855970,
      0.031648,
      NULL,
      1,
      1.297790,
      0.865625,
      1,
      1.040316,
      NULL,
      1,
      5,
      1.069971,
      0.179822,
      0,
      1.794612,
      5,
      0.667959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711614,
      4.346602,
      1.162881,
      1.403552,
      NULL,
      NULL,
      4.594736,
      3.802016,
      7,
      0.444778,
      6,
      4,
      2.430317,
      4,
      4,
      2.061446,
      0,
      0,
      6.803511,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.043611,
      0.356796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.595310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.643693,
      NULL,
      7,
      0.393484,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.837430,
      6.428151,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059886,
      3,
      1.620973,
      NULL,
      NULL,
      3,
      NULL,
      0.924244,
      0.584535,
      NULL,
      0.006962,
      0,
      0.536483,
      0,
      0,
      1,
      1,
      1,
      1.298540,
      1.988740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.012794,
      '03020',
      NULL,
      '',
      0,
      '00110',
      '',
      '',
      2,
      '0011',
      '',
      '',
      1.569758,
      3.366155,
      3,
      2,
      0,
      3,
      1,
      NULL,
      2.228040);
commit;
end;
/


