set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220814';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13030110',
      33.077978,
      58,
      '2122140',
      165,
      NULL,
      NULL,
      2,
      '211041',
      NULL,
      ' 7-17-1983',
      NULL,
      NULL,
      1,
      NULL,
      0.632358,
      1.930025,
      0.550656,
      1.289017,
      0.118648,
      0.423354,
      NULL,
      1.547128,
      1.364764,
      0.692272,
      3,
      NULL,
      1,
      0.159686,
      1,
      0,
      0.914994,
      1.856279,
      0,
      1.019341,
      0.499095,
      NULL,
      1,
      1,
      NULL,
      1.184136,
      1,
      0,
      NULL,
      NULL,
      0.050720,
      NULL,
      NULL,
      0.433856,
      1,
      0,
      0.132894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377732,
      0.115040,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078428,
      2,
      1,
      2,
      1,
      1.757935,
      0.056280,
      1.509494,
      1.659679,
      1.899070,
      0,
      0.615415,
      0.532511,
      0,
      0.128765,
      NULL,
      1,
      1.726469,
      NULL,
      1.282313,
      NULL,
      1.917451,
      NULL,
      1.116758,
      0.192638,
      0,
      0,
      NULL,
      NULL,
      5.495949,
      0,
      0,
      1.271508,
      5.504707,
      NULL,
      0,
      3.354841,
      1,
      4.210326,
      5.316726,
      6.891537,
      2.616394,
      8.959076,
      0,
      2,
      3,
      4.139489,
      NULL,
      NULL,
      NULL,
      6.818705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.474884,
      NULL,
      0,
      0,
      1.295007,
      1.511688,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9,
      0,
      3,
      0.749859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.022946,
      1.897271,
      3,
      1.331831,
      0.285144,
      0,
      2.395122,
      0.336479,
      0.084782,
      1.792578,
      0,
      0,
      5.363392,
      0,
      NULL,
      NULL,
      1.036596,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770849,
      0.271531,
      1,
      1.408540,
      2.587113,
      1,
      NULL,
      1.857484,
      1,
      NULL,
      1.670995,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.367751,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.433789,
      '24033',
      '',
      '',
      2.463028,
      '20201',
      '',
      NULL,
      2,
      NULL,
      NULL,
      '',
      4.430221,
      5.103863,
      NULL,
      2.880590,
      2.379135,
      0.441560,
      1.192299,
      NULL,
      1.806700);
commit;
end;
/


