set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220814';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00011123',
      79.859894,
      NULL,
      '0331132',
      108.300860,
      0,
      1.719785,
      1,
      NULL,
      1.141467,
      ' 6-14-1977',
      28,
      25.094337,
      1,
      NULL,
      3,
      1.065640,
      NULL,
      0.529363,
      0,
      1,
      1,
      1,
      2.743394,
      0,
      2,
      1.497389,
      1,
      1.019435,
      0.731463,
      0,
      7.516007,
      0.742647,
      0.073852,
      1.432210,
      0.260448,
      1.922732,
      2,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.291346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386542,
      NULL,
      1.523679,
      1,
      3.214029,
      1.713831,
      NULL,
      NULL,
      1,
      0.604015,
      1.149298,
      1,
      1.219217,
      NULL,
      1,
      0,
      0,
      1.540505,
      1,
      NULL,
      1,
      NULL,
      1.221071,
      1,
      1,
      0,
      1,
      NULL,
      3.661622,
      5,
      5.904892,
      4,
      1,
      NULL,
      5.301638,
      1,
      1.098603,
      5.000713,
      NULL,
      2.596313,
      1.041821,
      5.500500,
      4,
      8,
      7.998347,
      2,
      4.439101,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.862011,
      NULL,
      0.536442,
      2,
      1,
      0.734231,
      0.222920,
      NULL,
      1,
      0,
      1.198291,
      NULL,
      0.437840,
      0.864281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.354524,
      NULL,
      6,
      1.606323,
      3.782746,
      1.936233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      2.421122,
      0,
      1,
      NULL,
      1.453515,
      NULL,
      NULL,
      0.251669,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.514626,
      0,
      0.828382,
      1,
      0,
      2.764862,
      NULL,
      1.234017,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1.015181,
      1,
      0.953646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.560278,
      '24333',
      '',
      NULL,
      1,
      '02431',
      '',
      '',
      2.467148,
      '03113',
      '',
      '',
      1,
      1,
      0.558256,
      5,
      1,
      2.651326,
      2.744146,
      2.127800,
      3);
commit;
end;
/


