set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220814';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4010',
      '21234142',
      NULL,
      43.821483,
      '0342134',
      27.204452,
      2,
      3,
      NULL,
      '230043',
      NULL,
      NULL,
      36.506236,
      65,
      NULL,
      NULL,
      1,
      0,
      1.385344,
      0.692939,
      0,
      3.058333,
      1.112511,
      0.635919,
      0,
      NULL,
      1.295736,
      1.915809,
      1,
      0.474798,
      NULL,
      0.316471,
      4,
      NULL,
      0.161832,
      0,
      0.520458,
      0.375873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364221,
      1,
      0.905566,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337628,
      NULL,
      1.604049,
      0.762842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      3.103608,
      1.182485,
      1.649690,
      1,
      0,
      0.819331,
      1.580387,
      1.985269,
      1,
      NULL,
      1,
      1,
      1,
      1.291724,
      0.183644,
      NULL,
      1.613551,
      1.267589,
      0.911402,
      1,
      1,
      1.235732,
      0,
      0,
      0,
      NULL,
      NULL,
      2.881385,
      4,
      NULL,
      5.416424,
      NULL,
      0.784658,
      NULL,
      1,
      NULL,
      1,
      1.786119,
      NULL,
      NULL,
      1.526379,
      2.893407,
      0,
      1.673160,
      0.187329,
      NULL,
      NULL,
      1.063238,
      0.531399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698326,
      1.361140,
      NULL,
      NULL,
      1,
      0.641249,
      1,
      1.853918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.467452,
      NULL,
      8,
      NULL,
      0.019211,
      0.707490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.337438,
      3,
      3,
      NULL,
      2.536100,
      1.290054,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.542143,
      2,
      0.586140,
      NULL,
      3.767568,
      1.900378,
      1.853362,
      0,
      3,
      NULL,
      1.301192,
      0.288803,
      1,
      1.182069,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22130',
      NULL,
      '',
      0,
      '31441',
      '',
      '',
      0.219781,
      '40422',
      '',
      '',
      3,
      3.810951,
      1.976713,
      3,
      3.678384,
      3.235717,
      1,
      NULL,
      0.826117);
commit;
end;
/


