set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0100555';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4202',
      '22421234',
      50,
      52.611332,
      NULL,
      10,
      5,
      2,
      NULL,
      '140400',
      2.109384,
      ' 0-29-1990',
      NULL,
      1,
      NULL,
      NULL,
      1.339641,
      1,
      1.252603,
      0,
      0.145233,
      1,
      0,
      0,
      0,
      0,
      3,
      1,
      1.182022,
      3,
      1,
      1.428055,
      1,
      1,
      1.363727,
      NULL,
      1.528282,
      0.647393,
      NULL,
      1,
      2,
      0.158218,
      1.142574,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.297953,
      0.842307,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.605311,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.038693,
      5,
      1,
      NULL,
      1.126383,
      1,
      0,
      0.519320,
      1.179460,
      0.828810,
      1.972141,
      1,
      1,
      0,
      0,
      1.606334,
      0,
      0.506583,
      0.558036,
      NULL,
      1,
      0.504514,
      NULL,
      1.367962,
      1,
      1,
      1,
      0,
      3.884946,
      3.022520,
      6.042455,
      1,
      1,
      0,
      2,
      0,
      7,
      2.487127,
      9.246398,
      9.999586,
      6,
      3.148691,
      5.043406,
      3,
      2.126685,
      2,
      NULL,
      NULL,
      2,
      1.833555,
      1.402976,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340939,
      0.233513,
      0,
      1,
      1.348819,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.593703,
      NULL,
      2.746816,
      2.226561,
      NULL,
      2,
      0,
      NULL,
      1.158112,
      0,
      7,
      1.161075,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.651240,
      0.921224,
      NULL,
      NULL,
      6.060062,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.714518,
      7.897301,
      0.936169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      3,
      0.376631,
      NULL,
      0.116912,
      NULL,
      NULL,
      2.206999,
      NULL,
      NULL,
      1.467359,
      0,
      0.362144,
      0.867924,
      0.717680,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      '00320',
      NULL,
      '',
      3,
      '1203',
      '',
      '',
      1.119731,
      '',
      '',
      '',
      0.765873,
      2.691408,
      4,
      1.809179,
      0.298400,
      NULL,
      2.889537,
      NULL,
      1.825164);
commit;
end;
/


